/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto;

import de.schlichtherle.truezip.crypto.SeekableBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class SICSeekableBlockCipher
implements SeekableBlockCipher {
    protected final BlockCipher cipher;
    protected final int blockSize;
    protected long blockCounter;
    protected final byte[] IV;
    protected final byte[] cipherIn;
    protected final byte[] cipherOut;

    public SICSeekableBlockCipher(BlockCipher cipher) {
        this.cipher = cipher;
        this.blockSize = cipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.cipherIn = new byte[this.blockSize];
        this.cipherOut = new byte[this.blockSize];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        ParametersWithIV ivParams = (ParametersWithIV)params;
        byte[] iv = ivParams.getIV();
        System.arraycopy(iv, 0, this.IV, 0, this.IV.length);
        this.reset();
        this.cipher.init(true, ivParams.getParameters());
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/SIC";
    }

    @Override
    public int getBlockSize() {
        assert (this.blockSize == this.cipher.getBlockSize());
        return this.blockSize;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        int blockSize;
        this.incCounter();
        this.cipher.processBlock(this.cipherIn, 0, this.cipherOut, 0);
        int i = blockSize = this.blockSize;
        inOff += i;
        outOff += i;
        while (i > 0) {
            out[--outOff] = (byte)(in[--inOff] ^ this.cipherOut[--i]);
        }
        return blockSize;
    }

    private void incCounter() {
        int blockSize = this.blockSize;
        long blockCounter = this.blockCounter++;
        int i = blockSize;
        while (--i >= 0) {
            this.cipherIn[i] = (byte)(blockCounter += (long)(this.IV[i] & 0xFF));
            blockCounter >>>= 8;
        }
    }

    @Override
    public void setBlockCounter(long blockCounter) {
        this.blockCounter = blockCounter;
    }

    @Override
    public long getBlockCounter() {
        return this.blockCounter;
    }

    @Override
    public void reset() {
        this.cipher.reset();
        this.blockCounter = 0L;
    }
}

