/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;

final class TrackingLockFactory
extends LockFactory {
    private final LockFactory delegate;
    private final Set<TrackingLock> emittedLocks;

    TrackingLockFactory(LockFactory delegate) {
        this.delegate = Preconditions.checkNotNull(delegate);
        this.emittedLocks = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    Set<? extends Lock> getEmittedLocks(String name) {
        HashSet<TrackingLock> result = new HashSet<TrackingLock>();
        for (TrackingLock lock : this.emittedLocks) {
            if (name != null && !name.equals(lock.getName())) continue;
            result.add(lock);
        }
        return result;
    }

    @Override
    public Lock obtainLock(Directory dir, String lockName) throws IOException {
        TrackingLock lck = new TrackingLock(this.delegate.obtainLock(dir, lockName), lockName);
        this.emittedLocks.add(lck);
        return lck;
    }

    private final class TrackingLock
    extends Lock {
        private final Lock delegate;
        private final String name;

        TrackingLock(Lock delegate, String name) {
            this.delegate = Preconditions.checkNotNull(delegate);
            this.name = Preconditions.checkNotNull(name);
        }

        String getName() {
            return this.name;
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                TrackingLockFactory.this.emittedLocks.remove(this);
            }
        }

        @Override
        public void ensureValid() throws IOException {
            this.delegate.ensureValid();
        }
    }
}

