package org.apache.maven.artifact.ant;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.artifact.repository.ArtifactRepository;

/**
 * Support for install/deploy tasks.
 *
 * @author <a href="mailto:jdillon@apache.org">Jason Dillon</a>
 * @version $Id: InstallDeployTaskSupport.java 884304 2009-11-25 22:25:22Z pgier $
 */
public abstract class InstallDeployTaskSupport
    extends AbstractArtifactTask
{
    /**
     * The file to install/deploy.
     */
    protected File file;

    /**
     * Additional attached artifacts to install/deploy
     */
    protected List attachedArtifacts = new ArrayList();

    public File getFile()
    {
        return file;
    }

    public void setFile( File file )
    {
        this.file = file;
    }
    
    public Pom initializePom( ArtifactRepository localArtifactRepository )
    {
        Pom pom = super.initializePom( localArtifactRepository );

        // attach artifacts
        if ( attachedArtifacts != null )
        {
            Iterator iter = attachedArtifacts.iterator();

            while ( iter.hasNext() )
            {
                AttachedArtifact attached = (AttachedArtifact) iter.next();
                pom.attach( attached );
            }
        }
        
        return pom;
    }

    public AttachedArtifact createAttach()
    {
        AttachedArtifact attach = new AttachedArtifact();
        attachedArtifacts.add( attach );

        return attach;
    }
}
