/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.shaded.FileUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DebugResolutionListener;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.resolver.WarningResolutionListener;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.transform.ArtifactTransformationManager;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class DefaultArtifactResolver
extends AbstractLogEnabled
implements ArtifactResolver {
    private static final int DEFAULT_POOL_SIZE = 5;
    private WagonManager wagonManager;
    private ArtifactTransformationManager transformationManager;
    protected ArtifactFactory artifactFactory;
    private ArtifactCollector artifactCollector;
    private final ThreadPoolExecutor resolveArtifactPool = new ThreadPoolExecutor(5, 5, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue());

    public void resolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.resolve(artifact, remoteRepositories, localRepository, false);
    }

    public void resolveAlways(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.resolve(artifact, remoteRepositories, localRepository, true);
    }

    private void resolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository, boolean force) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (artifact == null) {
            return;
        }
        if ("system".equals(artifact.getScope())) {
            File systemFile = artifact.getFile();
            if (systemFile == null) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " has no file attached", artifact);
            }
            if (!systemFile.isFile()) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " is not a file: " + systemFile, artifact);
            }
            if (!systemFile.exists()) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " not found in path: " + systemFile, artifact);
            }
            artifact.setResolved(true);
        } else if (!artifact.isResolved()) {
            File destination;
            block24: {
                String localPath = localRepository.pathOf(artifact);
                artifact.setFile(new File(localRepository.getBasedir(), localPath));
                this.transformationManager.transformForResolve(artifact, remoteRepositories, localRepository);
                boolean localCopy = false;
                for (ArtifactMetadata m : artifact.getMetadataList()) {
                    Snapshot snapshot;
                    Versioning versioning;
                    SnapshotArtifactRepositoryMetadata snapshotMetadata;
                    Metadata metadata;
                    if (!(m instanceof SnapshotArtifactRepositoryMetadata) || (metadata = (snapshotMetadata = (SnapshotArtifactRepositoryMetadata)m).getMetadata()) == null || (versioning = metadata.getVersioning()) == null || (snapshot = versioning.getSnapshot()) == null) continue;
                    localCopy = snapshot.isLocalCopy();
                }
                destination = artifact.getFile();
                ArrayList repositories = remoteRepositories;
                if (artifact.isSnapshot() && artifact.getBaseVersion().equals(artifact.getVersion()) && destination.exists() && !localCopy && this.wagonManager.isOnline()) {
                    Date comparisonDate = new Date(destination.lastModified());
                    repositories = new ArrayList(remoteRepositories);
                    Iterator i = repositories.iterator();
                    while (i.hasNext()) {
                        ArtifactRepository repository = (ArtifactRepository)i.next();
                        ArtifactRepositoryPolicy policy = repository.getSnapshots();
                        if (policy.isEnabled() && policy.checkOutOfDate(comparisonDate)) continue;
                        i.remove();
                    }
                    if (!repositories.isEmpty()) {
                        force = true;
                    }
                }
                if (!destination.exists() || force) {
                    if (!this.wagonManager.isOnline()) {
                        throw new ArtifactNotFoundException("System is offline.", artifact);
                    }
                    try {
                        if (artifact.getRepository() != null) {
                            this.wagonManager.getArtifact(artifact, artifact.getRepository());
                        } else {
                            this.wagonManager.getArtifact(artifact, repositories);
                        }
                        if (!artifact.isResolved() && !destination.exists()) {
                            throw new ArtifactResolutionException("Failed to resolve artifact, possibly due to a repository list that is not appropriately equipped for this artifact's metadata.", artifact, this.getMirroredRepositories(remoteRepositories));
                        }
                        break block24;
                    }
                    catch (ResourceDoesNotExistException e) {
                        throw new ArtifactNotFoundException(e.getMessage(), artifact, this.getMirroredRepositories(remoteRepositories), e);
                    }
                    catch (TransferFailedException e) {
                        throw new ArtifactResolutionException(e.getMessage(), artifact, this.getMirroredRepositories(remoteRepositories), e);
                    }
                }
                if (destination.exists()) {
                    artifact.setResolved(true);
                }
            }
            if (artifact.isSnapshot() && !artifact.getBaseVersion().equals(artifact.getVersion())) {
                String version = artifact.getVersion();
                artifact.selectVersion(artifact.getBaseVersion());
                File copy = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
                if (!copy.exists() || copy.lastModified() != destination.lastModified() || copy.length() != destination.length()) {
                    try {
                        FileUtils.copyFile(destination, copy);
                        copy.setLastModified(destination.lastModified());
                    }
                    catch (IOException e) {
                        throw new ArtifactResolutionException("Unable to copy resolved artifact for local use: " + e.getMessage(), artifact, this.getMirroredRepositories(remoteRepositories), e);
                    }
                }
                artifact.setFile(copy);
                artifact.selectVersion(version);
            }
        }
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, filter);
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArrayList<ResolutionListener> listeners = new ArrayList<ResolutionListener>();
        if (this.getLogger().isDebugEnabled()) {
            listeners.add(new DebugResolutionListener(this.getLogger()));
        }
        listeners.add(new WarningResolutionListener(this.getLogger()));
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, listeners);
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List listeners) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArtifactResolutionResult artifactResolutionResult = this.artifactCollector.collect(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, listeners);
        List resolvedArtifacts = Collections.synchronizedList(new ArrayList());
        List missingArtifacts = Collections.synchronizedList(new ArrayList());
        CountDownLatch latch = new CountDownLatch(artifactResolutionResult.getArtifactResolutionNodes().size());
        HashMap<String, ArrayList<ResolutionNode>> nodesByGroupId = new HashMap<String, ArrayList<ResolutionNode>>();
        for (ResolutionNode node : artifactResolutionResult.getArtifactResolutionNodes()) {
            List<ResolutionNode> nodes = (ArrayList<ResolutionNode>)nodesByGroupId.get(node.getArtifact().getGroupId());
            if (nodes == null) {
                nodes = new ArrayList<ResolutionNode>();
                nodesByGroupId.put(node.getArtifact().getGroupId(), (ArrayList<ResolutionNode>)nodes);
            }
            nodes.add(node);
        }
        List resolutionExceptions = Collections.synchronizedList(new ArrayList());
        try {
            for (List<ResolutionNode> nodes : nodesByGroupId.values()) {
                this.resolveArtifactPool.execute(new ResolveArtifactTask(this.resolveArtifactPool, latch, nodes, localRepository, resolvedArtifacts, missingArtifacts, resolutionExceptions));
            }
            latch.await();
        }
        catch (InterruptedException e) {
            throw new ArtifactResolutionException("Resolution interrupted", originatingArtifact, e);
        }
        if (!resolutionExceptions.isEmpty()) {
            throw (ArtifactResolutionException)resolutionExceptions.get(0);
        }
        if (missingArtifacts.size() > 0) {
            throw new MultipleArtifactsNotFoundException(originatingArtifact, resolvedArtifacts, missingArtifacts, this.getMirroredRepositories(remoteRepositories));
        }
        return artifactResolutionResult;
    }

    private List getMirroredRepositories(List remoteRepositories) {
        HashMap<String, ArtifactRepository> repos = new HashMap<String, ArtifactRepository>();
        for (ArtifactRepository repository : remoteRepositories) {
            ArtifactRepository repo = this.wagonManager.getMirrorRepository(repository);
            repos.put(repo.getId(), repo);
        }
        return new ArrayList(repos.values());
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, List remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, localRepository, remoteRepositories, source, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, List remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source, List listeners) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, null, listeners);
    }

    public synchronized void configureNumberOfThreads(int threads) {
        this.resolveArtifactPool.setCorePoolSize(threads);
        this.resolveArtifactPool.setMaximumPoolSize(threads);
    }

    void setWagonManager(WagonManager wagonManager) {
        this.wagonManager = wagonManager;
    }

    private class ResolveArtifactTask
    implements Runnable {
        private List nodes;
        private ArtifactRepository localRepository;
        private List resolvedArtifacts;
        private List missingArtifacts;
        private CountDownLatch latch;
        private ThreadPoolExecutor pool;
        private List resolutionExceptions;

        public ResolveArtifactTask(ThreadPoolExecutor pool, CountDownLatch latch, List nodes, ArtifactRepository localRepository, List resolvedArtifacts, List missingArtifacts, List resolutionExceptions) {
            this.nodes = nodes;
            this.localRepository = localRepository;
            this.resolvedArtifacts = resolvedArtifacts;
            this.missingArtifacts = missingArtifacts;
            this.latch = latch;
            this.pool = pool;
            this.resolutionExceptions = resolutionExceptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Iterator i = this.nodes.iterator();
            ResolutionNode node = (ResolutionNode)i.next();
            i.remove();
            try {
                this.resolveArtifact(node);
            }
            catch (ArtifactResolutionException e) {
                this.resolutionExceptions.add(e);
            }
            finally {
                this.latch.countDown();
                if (i.hasNext()) {
                    this.pool.execute(new ResolveArtifactTask(this.pool, this.latch, this.nodes, this.localRepository, this.resolvedArtifacts, this.missingArtifacts, this.resolutionExceptions));
                }
            }
        }

        private void resolveArtifact(ResolutionNode node) throws ArtifactResolutionException {
            try {
                DefaultArtifactResolver.this.resolve(node.getArtifact(), node.getRemoteRepositories(), this.localRepository);
                this.resolvedArtifacts.add(node.getArtifact());
            }
            catch (ArtifactNotFoundException anfe) {
                DefaultArtifactResolver.this.getLogger().debug(anfe.getMessage(), anfe);
                this.missingArtifacts.add(node.getArtifact());
            }
        }
    }
}

