/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.codehaus.plexus.util.StringUtils;

public class DefaultArtifact
implements Artifact {
    private final String groupId;
    private final String artifactId;
    private String version;
    private String baseVersion;
    private final String type;
    private final String classifier;
    private String scope;
    private List metadataList;
    private File file;
    private ArtifactRepository repository;
    private String downloadUrl;
    private ArtifactFilter dependencyFilter;
    private final ArtifactHandler artifactHandler;
    private List dependencyTrail;

    public DefaultArtifact(String groupId, String artifactId, String version, String scope, String type, String classifier, ArtifactHandler artifactHandler) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.artifactHandler = artifactHandler;
        this.scope = scope;
        this.type = type;
        this.classifier = classifier;
        this.validateIdentity();
    }

    private void validateIdentity() {
        if (this.empty(this.groupId)) {
            throw new InvalidArtifactRTException(this.groupId, this.artifactId, this.version, this.type, "The groupId cannot be empty.");
        }
        if (this.artifactId == null) {
            throw new InvalidArtifactRTException(this.groupId, this.artifactId, this.version, this.type, "The artifactId cannot be empty.");
        }
        if (this.type == null) {
            throw new InvalidArtifactRTException(this.groupId, this.artifactId, this.version, this.type, "The type cannot be empty.");
        }
        if (this.version == null) {
            throw new InvalidArtifactRTException(this.groupId, this.artifactId, this.version, this.type, "The version cannot be empty.");
        }
    }

    private boolean empty(String value) {
        return value == null || value.trim().length() < 1;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean hasClassifier() {
        return StringUtils.isNotEmpty((String)this.classifier);
    }

    public String getScope() {
        return this.scope;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public void setRepository(ArtifactRepository repository) {
        this.repository = repository;
    }

    public String getId() {
        return this.getDependencyConflictId() + (this.hasClassifier() ? ":" + this.getClassifier() : "") + ":" + this.getBaseVersion();
    }

    public String getDependencyConflictId() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getType();
    }

    public void addMetadata(ArtifactMetadata metadata) {
        if (this.metadataList == null) {
            this.metadataList = new ArrayList();
        }
        this.metadataList.add(metadata);
    }

    public List getMetadataList() {
        return this.metadataList == null ? Collections.EMPTY_LIST : this.metadataList;
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.groupId.hashCode();
        result = 37 * result + this.artifactId.hashCode();
        result = 37 * result + this.type.hashCode();
        result = 37 * result + this.version.hashCode();
        result = 37 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Artifact)) {
            return false;
        }
        Artifact a = (Artifact)o;
        if (!a.getGroupId().equals(this.groupId)) {
            return false;
        }
        if (!a.getArtifactId().equals(this.artifactId)) {
            return false;
        }
        if (!a.getVersion().equals(this.version)) {
            return false;
        }
        if (!a.getType().equals(this.type)) {
            return false;
        }
        return !(this.classifier == null ? a.getClassifier() != null : !a.getClassifier().equals(this.classifier));
    }

    public String getBaseVersion() {
        if (this.baseVersion == null) {
            this.baseVersion = this.version;
            if (this.version == null) {
                throw new NullPointerException("version was null for " + this.groupId + ":" + this.artifactId);
            }
        }
        return this.baseVersion;
    }

    public void setBaseVersion(String baseVersion) {
        this.baseVersion = baseVersion;
    }

    public int compareTo(Object o) {
        Artifact a = (Artifact)o;
        int result = this.groupId.compareTo(a.getGroupId());
        if (result == 0 && (result = this.artifactId.compareTo(a.getArtifactId())) == 0 && (result = this.type.compareTo(a.getType())) == 0) {
            if (this.classifier == null) {
                if (a.getClassifier() != null) {
                    result = 1;
                }
            } else {
                result = a.getClassifier() != null ? this.classifier.compareTo(a.getClassifier()) : -1;
            }
            if (result == 0) {
                result = this.version.compareTo(a.getVersion());
            }
        }
        return result;
    }

    public void updateVersion(String version, ArtifactRepository localRepository) {
        this.setVersion(version);
        this.setFile(new File(localRepository.getBasedir(), localRepository.pathOf(this)));
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public ArtifactFilter getDependencyFilter() {
        return this.dependencyFilter;
    }

    public void setDependencyFilter(ArtifactFilter artifactFilter) {
        this.dependencyFilter = artifactFilter;
    }

    public ArtifactHandler getArtifactHandler() {
        return this.artifactHandler;
    }

    public List getDependencyTrail() {
        return this.dependencyTrail;
    }

    public void setDependencyTrail(List dependencyTrail) {
        this.dependencyTrail = dependencyTrail;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

