/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.CyclicDependencyException;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.TransitiveArtifactResolutionException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

public class DefaultArtifactCollector
implements ArtifactCollector {
    public ArtifactResolutionResult collect(Set artifacts, Artifact originatingArtifact, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, ArtifactFactory artifactFactory, List listeners) throws ArtifactResolutionException {
        return this.collect(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, filter, artifactFactory, listeners);
    }

    public ArtifactResolutionResult collect(Set artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, ArtifactFactory artifactFactory, List listeners) throws ArtifactResolutionException {
        HashMap resolvedArtifacts = new HashMap();
        ResolutionNode root = new ResolutionNode(originatingArtifact);
        root.addDependencies(artifacts, filter);
        this.recurse(root, resolvedArtifacts, managedVersions, localRepository, remoteRepositories, source, filter, artifactFactory, listeners);
        HashSet<Artifact> set = new HashSet<Artifact>();
        Iterator i = resolvedArtifacts.values().iterator();
        while (i.hasNext()) {
            ResolutionNode node = (ResolutionNode)i.next();
            if (node == root) continue;
            Artifact artifact = node.getArtifact();
            artifact.setDependencyTrail(node.getDependencyTrail());
            set.add(artifact);
        }
        ArtifactResolutionResult result = new ArtifactResolutionResult();
        result.setArtifacts(set);
        return result;
    }

    private void recurse(ResolutionNode node, Map resolvedArtifacts, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, ArtifactFactory artifactFactory, List listeners) throws CyclicDependencyException, TransitiveArtifactResolutionException {
        ResolutionNode previous;
        this.fireEvent(1, listeners, node);
        Object key = node.getKey();
        if (managedVersions.containsKey(key)) {
            Artifact artifact = (Artifact)managedVersions.get(key);
            this.fireEvent(7, listeners, node, artifact);
            if (artifact.getVersion() != null) {
                node.getArtifact().setVersion(artifact.getVersion());
            }
            if (artifact.getScope() != null) {
                node.getArtifact().setScope(artifact.getScope());
            }
        }
        if ((previous = (ResolutionNode)resolvedArtifacts.get(key)) != null) {
            if (previous.getDepth() <= node.getDepth()) {
                this.checkScopeUpdate(node, previous, artifactFactory, listeners);
            } else {
                this.checkScopeUpdate(previous, node, artifactFactory, listeners);
            }
            if (previous.getDepth() <= node.getDepth()) {
                this.fireEvent(5, listeners, node, previous.getArtifact());
                return;
            }
        }
        resolvedArtifacts.put(key, node);
        this.fireEvent(4, listeners, node);
        this.fireEvent(2, listeners, node);
        Iterator i = node.getChildrenIterator();
        while (i.hasNext()) {
            ResolutionNode child = (ResolutionNode)i.next();
            if (child.isResolved()) continue;
            try {
                Set artifacts = source.retrieve(child.getArtifact(), localRepository, remoteRepositories);
                child.addDependencies(artifacts, filter);
            }
            catch (CyclicDependencyException e) {
                this.fireEvent(8, listeners, new ResolutionNode(e.getArtifact(), child));
            }
            catch (ArtifactMetadataRetrievalException e) {
                child.getArtifact().setDependencyTrail(node.getDependencyTrail());
                throw new TransitiveArtifactResolutionException(e.getMessage(), child.getArtifact(), remoteRepositories, e);
            }
            this.recurse(child, resolvedArtifacts, managedVersions, localRepository, remoteRepositories, source, filter, artifactFactory, listeners);
        }
        this.fireEvent(3, listeners, node);
    }

    private void checkScopeUpdate(ResolutionNode node, ResolutionNode previous, ArtifactFactory artifactFactory, List listeners) {
        boolean updateScope = false;
        Artifact newArtifact = node.getArtifact();
        Artifact previousArtifact = previous.getArtifact();
        if ("runtime".equals(newArtifact.getScope()) && ("test".equals(previousArtifact.getScope()) || "provided".equals(previousArtifact.getScope()))) {
            updateScope = true;
        }
        if ("compile".equals(newArtifact.getScope()) && !"compile".equals(previousArtifact.getScope())) {
            updateScope = true;
        }
        if (updateScope) {
            this.fireEvent(6, listeners, previous, newArtifact);
            Artifact artifact = artifactFactory.createArtifact(previousArtifact.getGroupId(), previousArtifact.getArtifactId(), previousArtifact.getVersion(), newArtifact.getScope(), previousArtifact.getType());
            previous.setArtifact(artifact);
        }
    }

    private void fireEvent(int event, List listeners, ResolutionNode node) {
        this.fireEvent(event, listeners, node, null);
    }

    private void fireEvent(int event, List listeners, ResolutionNode node, Artifact replacement) {
        Iterator i = listeners.iterator();
        block10: while (i.hasNext()) {
            ResolutionListener listener = (ResolutionListener)i.next();
            switch (event) {
                case 1: {
                    listener.testArtifact(node.getArtifact());
                    continue block10;
                }
                case 2: {
                    listener.startProcessChildren(node.getArtifact());
                    continue block10;
                }
                case 3: {
                    listener.endProcessChildren(node.getArtifact());
                    continue block10;
                }
                case 4: {
                    listener.includeArtifact(node.getArtifact());
                    continue block10;
                }
                case 5: {
                    listener.omitForNearer(node.getArtifact(), replacement);
                    continue block10;
                }
                case 8: {
                    listener.omitForCycle(node.getArtifact());
                    continue block10;
                }
                case 6: {
                    listener.updateScope(node.getArtifact(), replacement.getScope());
                    continue block10;
                }
                case 7: {
                    listener.manageArtifact(node.getArtifact(), replacement);
                    continue block10;
                }
            }
            throw new IllegalStateException("Unknown event: " + event);
        }
    }

    private static class ResolutionNode {
        private Artifact artifact;
        private List children = null;
        private final List parents;
        private final int depth;
        private final ResolutionNode parent;

        public ResolutionNode(Artifact artifact) {
            this.artifact = artifact;
            this.depth = 0;
            this.parents = Collections.EMPTY_LIST;
            this.parent = null;
        }

        public ResolutionNode(Artifact artifact, ResolutionNode parent) {
            this.artifact = artifact;
            this.depth = parent.depth + 1;
            this.parents = new ArrayList();
            this.parents.addAll(parent.parents);
            this.parents.add(parent.getKey());
            this.parent = parent;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public Object getKey() {
            return this.artifact.getDependencyConflictId();
        }

        public void addDependencies(Set artifacts, ArtifactFilter filter) throws CyclicDependencyException {
            this.children = new ArrayList(artifacts.size());
            Iterator i = artifacts.iterator();
            while (i.hasNext()) {
                Artifact a = (Artifact)i.next();
                if (filter != null && !filter.include(a)) continue;
                if (this.parents.contains(a.getDependencyConflictId())) {
                    a.setDependencyTrail(this.getDependencyTrail());
                    throw new CyclicDependencyException("A dependency has introduced a cycle", a);
                }
                this.children.add(new ResolutionNode(a, this));
            }
        }

        public List getDependencyTrail() {
            LinkedList<String> path = new LinkedList<String>();
            ResolutionNode node = this;
            while (node != null) {
                path.add(0, node.getArtifact().getId());
                node = node.parent;
            }
            return path;
        }

        public boolean isResolved() {
            return this.children != null;
        }

        public Iterator getChildrenIterator() {
            return this.children.iterator();
        }

        public int getDepth() {
            return this.depth;
        }

        public void setArtifact(Artifact artifact) {
            this.artifact = artifact;
        }
    }
}

