/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=MavenProjectBuilder.class)
@Deprecated
public class DefaultMavenProjectBuilder
implements MavenProjectBuilder {
    @Requirement
    private ProjectBuilder projectBuilder;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private LegacySupport legacySupport;

    @Override
    public MavenProject build(File pomFile, ProjectBuilderConfiguration configuration) throws ProjectBuildingException {
        return this.projectBuilder.build(pomFile, (ProjectBuildingRequest)configuration).getProject();
    }

    public MavenProject buildFromRepository(Artifact artifact, ProjectBuilderConfiguration configuration, boolean allowStubModel) throws ProjectBuildingException {
        this.normalizeToArtifactRepositories(configuration);
        return this.projectBuilder.build(artifact, allowStubModel, (ProjectBuildingRequest)configuration).getProject();
    }

    private void normalizeToArtifactRepositories(ProjectBuilderConfiguration configuration) throws ProjectBuildingException {
        List repositories = configuration.getRemoteRepositories();
        if (repositories != null) {
            boolean normalized = false;
            ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>(repositories.size());
            for (Object repository : repositories) {
                if (repository instanceof Repository) {
                    try {
                        ArtifactRepository repo = this.repositorySystem.buildArtifactRepository((Repository)repository);
                        this.repositorySystem.injectMirror(Arrays.asList(repo), configuration.getMirrors());
                        this.repositorySystem.injectProxy(Arrays.asList(repo), configuration.getProxies());
                        this.repositorySystem.injectAuthentication(Arrays.asList(repo), configuration.getServers());
                        repos.add(repo);
                    }
                    catch (InvalidRepositoryException e) {
                        throw new ProjectBuildingException("", "Invalid remote repository " + repository, (Throwable)e);
                    }
                    normalized = true;
                    continue;
                }
                repos.add((ArtifactRepository)repository);
            }
            if (normalized) {
                configuration.setRemoteRepositories(repos);
            }
        }
    }

    @Override
    public MavenProject build(File project, ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException {
        ProjectBuilderConfiguration configuration = new DefaultProjectBuilderConfiguration().setLocalRepository(localRepository);
        return this.build(project, configuration);
    }

    @Override
    public MavenProject buildFromRepository(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, boolean allowStubModel) throws ProjectBuildingException {
        DefaultProjectBuilderConfiguration configuration = new DefaultProjectBuilderConfiguration();
        configuration.setLocalRepository(localRepository);
        configuration.setRemoteRepositories(remoteRepositories);
        configuration.setProcessPlugins(false);
        configuration.setValidationLevel(0);
        MavenSession session = this.legacySupport.getSession();
        if (session != null) {
            configuration.setSystemProperties(session.getSystemProperties());
            configuration.setUserProperties(session.getUserProperties());
        } else {
            configuration.setSystemProperties(System.getProperties());
        }
        try {
            return this.buildFromRepository(artifact, (ProjectBuilderConfiguration)configuration, allowStubModel);
        }
        catch (ProjectBuildingException e) {
            if (e.getCause() instanceof ModelBuildingException) {
                throw new InvalidProjectModelException(e.getProjectId(), e.getMessage(), e.getPomFile());
            }
            throw e;
        }
    }

    @Override
    public MavenProject buildFromRepository(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ProjectBuildingException {
        return this.buildFromRepository(artifact, remoteRepositories, localRepository, true);
    }

    @Override
    public MavenProject buildStandaloneSuperProject(ProjectBuilderConfiguration config) throws ProjectBuildingException {
        return this.projectBuilder.buildStandaloneSuperProject((ProjectBuildingRequest)config).getProject();
    }

    @Override
    public MavenProject buildStandaloneSuperProject(ArtifactRepository localRepository) throws ProjectBuildingException {
        return this.buildStandaloneSuperProject(localRepository, null);
    }

    @Override
    public MavenProject buildStandaloneSuperProject(ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException {
        DefaultProjectBuilderConfiguration configuration = new DefaultProjectBuilderConfiguration();
        configuration.setLocalRepository(localRepository);
        configuration.setProcessPlugins(false);
        configuration.setValidationLevel(0);
        if (profileManager != null) {
            configuration.setActiveProfileIds(profileManager.getExplicitlyActivatedIds());
            configuration.setInactiveProfileIds(profileManager.getExplicitlyDeactivatedIds());
        }
        return this.buildStandaloneSuperProject((ProjectBuilderConfiguration)configuration);
    }
}

