/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.legacy;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.repository.legacy.ChecksumFailedException;
import org.apache.maven.repository.legacy.UpdateCheckManager;
import org.apache.maven.repository.legacy.WagonManager;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.ChecksumObserver;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=WagonManager.class)
public class DefaultWagonManager
implements WagonManager {
    private static final String[] CHECKSUM_IDS = new String[]{"md5", "sha1"};
    private static final String[] CHECKSUM_ALGORITHMS = new String[]{"MD5", "SHA-1"};
    @Requirement
    private Logger logger;
    @Requirement
    private PlexusContainer container;
    @Requirement(role=Wagon.class)
    private Map<String, Wagon> wagons;
    @Requirement
    private UpdateCheckManager updateCheckManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getArtifact(Artifact artifact, ArtifactRepository repository, TransferListener downloadMonitor, boolean force) throws TransferFailedException, ResourceDoesNotExistException {
        ArtifactRepositoryPolicy policy;
        String remotePath = repository.pathOf(artifact);
        ArtifactRepositoryPolicy artifactRepositoryPolicy = policy = artifact.isSnapshot() ? repository.getSnapshots() : repository.getReleases();
        if (!policy.isEnabled()) {
            this.logger.debug("Skipping disabled repository " + repository.getId() + " for resolution of " + artifact.getId());
        } else if (artifact.isSnapshot() || !artifact.getFile().exists()) {
            if (force || this.updateCheckManager.isUpdateRequired(artifact, repository)) {
                this.logger.debug("Trying repository " + repository.getId() + " for resolution of " + artifact.getId() + " from " + remotePath);
                try {
                    this.getRemoteFile(repository, artifact.getFile(), remotePath, downloadMonitor, policy.getChecksumPolicy(), false);
                }
                finally {
                    this.updateCheckManager.touch(artifact, repository);
                }
                this.logger.debug("  Artifact " + artifact.getId() + " resolved to " + artifact.getFile());
                artifact.setResolved(true);
            } else if (!artifact.getFile().exists()) {
                throw new ResourceDoesNotExistException("Failure to resolve " + remotePath + " from " + repository.getUrl() + " was cached in the local repository. " + "Resolution will not be reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced.");
            }
        }
    }

    @Override
    public void getArtifact(Artifact artifact, List<ArtifactRepository> remoteRepositories, TransferListener downloadMonitor, boolean force) throws TransferFailedException, ResourceDoesNotExistException {
        TransferFailedException tfe = null;
        for (ArtifactRepository repository : remoteRepositories) {
            try {
                this.getArtifact(artifact, repository, downloadMonitor, force);
                if (!artifact.isResolved()) continue;
                artifact.setRepository(repository);
                break;
            }
            catch (ResourceDoesNotExistException e) {
                this.logger.debug("Unable to find resource '" + artifact.getId() + "' in repository " + repository.getId() + " (" + repository.getUrl() + ")", (Throwable)e);
            }
            catch (TransferFailedException e) {
                tfe = e;
                this.logger.debug("Unable to get resource '" + artifact.getId() + "' from repository " + repository.getId() + " (" + repository.getUrl() + ")", (Throwable)e);
            }
        }
        if (!artifact.getFile().exists()) {
            if (tfe != null) {
                throw tfe;
            }
            throw new ResourceDoesNotExistException("Unable to download the artifact from any repository");
        }
    }

    @Override
    public void getArtifactMetadata(ArtifactMetadata metadata, ArtifactRepository repository, File destination, String checksumPolicy) throws TransferFailedException, ResourceDoesNotExistException {
        String remotePath = repository.pathOfRemoteRepositoryMetadata(metadata);
        this.getRemoteFile(repository, destination, remotePath, null, checksumPolicy, true);
    }

    @Override
    public void getArtifactMetadataFromDeploymentRepository(ArtifactMetadata metadata, ArtifactRepository repository, File destination, String checksumPolicy) throws TransferFailedException, ResourceDoesNotExistException {
        String remotePath = repository.pathOfRemoteRepositoryMetadata(metadata);
        this.getRemoteFile(repository, destination, remotePath, null, checksumPolicy, true);
    }

    private void connectWagon(Wagon wagon, ArtifactRepository repository) throws ConnectionException, AuthenticationException {
        if (repository.getAuthentication() != null) {
            wagon.connect(new Repository(repository.getId(), repository.getUrl()), this.authenticationInfo(repository));
        } else if (repository.getProxy() != null) {
            wagon.connect(new Repository(repository.getId(), repository.getUrl()), this.proxyInfo(repository));
        } else if (repository.getAuthentication() != null && repository.getProxy() != null) {
            wagon.connect(new Repository(repository.getId(), repository.getUrl()), this.authenticationInfo(repository), this.proxyInfo(repository));
        } else {
            wagon.connect(new Repository(repository.getId(), repository.getUrl()));
        }
    }

    private AuthenticationInfo authenticationInfo(ArtifactRepository repository) {
        AuthenticationInfo ai = new AuthenticationInfo();
        ai.setUserName(repository.getAuthentication().getUsername());
        ai.setPassword(repository.getAuthentication().getPassword());
        return ai;
    }

    private ProxyInfo proxyInfo(ArtifactRepository repository) {
        ProxyInfo proxyInfo = new ProxyInfo();
        proxyInfo.setHost(repository.getProxy().getHost());
        proxyInfo.setType(repository.getProxy().getProtocol());
        proxyInfo.setPort(repository.getProxy().getPort());
        proxyInfo.setNonProxyHosts(repository.getProxy().getNonProxyHosts());
        proxyInfo.setUserName(repository.getProxy().getUserName());
        proxyInfo.setPassword(repository.getProxy().getPassword());
        return proxyInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getRemoteFile(ArtifactRepository repository, File destination, String remotePath, TransferListener downloadMonitor, String checksumPolicy, boolean force) throws TransferFailedException, ResourceDoesNotExistException {
        Wagon wagon;
        String protocol = repository.getProtocol();
        try {
            wagon = this.getWagon(protocol);
        }
        catch (UnsupportedProtocolException e) {
            throw new TransferFailedException("Unsupported Protocol: '" + protocol + "': " + e.getMessage(), (Throwable)e);
        }
        if (downloadMonitor != null) {
            wagon.addTransferListener(downloadMonitor);
        }
        File temp = new File(destination + ".tmp");
        temp.deleteOnExit();
        boolean downloaded = false;
        try {
            this.connectWagon(wagon, repository);
            boolean firstRun = true;
            boolean retry = true;
            while (firstRun || retry) {
                ChecksumObserver sha1ChecksumObserver;
                ChecksumObserver md5ChecksumObserver;
                block36: {
                    md5ChecksumObserver = null;
                    sha1ChecksumObserver = null;
                    try {
                        int i = 0;
                        md5ChecksumObserver = this.addChecksumObserver(wagon, CHECKSUM_ALGORITHMS[i++]);
                        sha1ChecksumObserver = this.addChecksumObserver(wagon, CHECKSUM_ALGORITHMS[i++]);
                        retry = false;
                        if (destination.exists() && !force) {
                            try {
                                downloaded = wagon.getIfNewer(remotePath, temp, destination.lastModified());
                                if (!downloaded) {
                                    destination.setLastModified(System.currentTimeMillis());
                                }
                                break block36;
                            }
                            catch (UnsupportedOperationException e) {
                                wagon.get(remotePath, temp);
                                downloaded = true;
                            }
                            break block36;
                        }
                        wagon.get(remotePath, temp);
                        downloaded = true;
                    }
                    catch (Throwable throwable) {
                        wagon.removeTransferListener(md5ChecksumObserver);
                        wagon.removeTransferListener(sha1ChecksumObserver);
                        throw throwable;
                    }
                }
                wagon.removeTransferListener((TransferListener)md5ChecksumObserver);
                wagon.removeTransferListener((TransferListener)sha1ChecksumObserver);
                if (downloaded) {
                    if (downloadMonitor != null) {
                        wagon.removeTransferListener(downloadMonitor);
                    }
                    try {
                        this.verifyChecksum(sha1ChecksumObserver, destination, temp, remotePath, ".sha1", wagon);
                    }
                    catch (ChecksumFailedException e) {
                        if (firstRun) {
                            this.logger.warn("*** CHECKSUM FAILED - " + e.getMessage() + " - RETRYING");
                            retry = true;
                        } else {
                            this.handleChecksumFailure(checksumPolicy, e.getMessage(), e.getCause());
                        }
                    }
                    catch (ResourceDoesNotExistException sha1TryException) {
                        this.logger.debug("SHA1 not found, trying MD5: " + sha1TryException.getMessage());
                        try {
                            this.verifyChecksum(md5ChecksumObserver, destination, temp, remotePath, ".md5", wagon);
                        }
                        catch (ChecksumFailedException e) {
                            if (firstRun) {
                                retry = true;
                            } else {
                                this.handleChecksumFailure(checksumPolicy, e.getMessage(), e.getCause());
                            }
                        }
                        catch (ResourceDoesNotExistException md5TryException) {
                            this.handleChecksumFailure(checksumPolicy, "Error retrieving checksum file for " + remotePath, md5TryException);
                        }
                    }
                    if (downloadMonitor != null) {
                        wagon.addTransferListener(downloadMonitor);
                    }
                }
                firstRun = false;
            }
        }
        catch (ConnectionException e) {
            throw new TransferFailedException("Connection failed: " + e.getMessage(), (Throwable)e);
        }
        catch (AuthenticationException e) {
            throw new TransferFailedException("Authentication failed: " + e.getMessage(), (Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new TransferFailedException("Authorization failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (downloadMonitor != null) {
                wagon.removeTransferListener(downloadMonitor);
            }
            this.disconnectWagon(wagon);
            this.releaseWagon(protocol, wagon);
        }
        if (downloaded) {
            if (!temp.exists()) {
                throw new ResourceDoesNotExistException("Downloaded file does not exist: " + temp);
            }
            if (!temp.renameTo(destination)) {
                try {
                    FileUtils.copyFile((File)temp, (File)destination);
                    temp.delete();
                }
                catch (IOException e) {
                    throw new TransferFailedException("Error copying temporary file to the final destination: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void putArtifact(File source, Artifact artifact, ArtifactRepository deploymentRepository, TransferListener downloadMonitor) throws TransferFailedException {
        this.putRemoteFile(deploymentRepository, source, deploymentRepository.pathOf(artifact), downloadMonitor);
    }

    @Override
    public void putArtifactMetadata(File source, ArtifactMetadata artifactMetadata, ArtifactRepository repository) throws TransferFailedException {
        this.logger.info("Uploading " + artifactMetadata);
        this.putRemoteFile(repository, source, repository.pathOfRemoteRepositoryMetadata(artifactMetadata), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putRemoteFile(ArtifactRepository repository, File source, String remotePath, TransferListener downloadMonitor) throws TransferFailedException {
        Wagon wagon;
        String protocol = repository.getProtocol();
        try {
            wagon = this.getWagon(protocol);
        }
        catch (UnsupportedProtocolException e) {
            throw new TransferFailedException("Unsupported Protocol: '" + protocol + "': " + e.getMessage(), (Throwable)e);
        }
        if (downloadMonitor != null) {
            wagon.addTransferListener(downloadMonitor);
        }
        HashMap<String, ChecksumObserver> checksums = new HashMap<String, ChecksumObserver>(2);
        HashMap<String, String> sums = new HashMap<String, String>(2);
        for (int i = 0; i < CHECKSUM_IDS.length; ++i) {
            checksums.put(CHECKSUM_IDS[i], this.addChecksumObserver(wagon, CHECKSUM_ALGORITHMS[i]));
        }
        try {
            try {
                this.connectWagon(wagon, repository);
                wagon.put(source, remotePath);
            }
            finally {
                if (downloadMonitor != null) {
                    wagon.removeTransferListener(downloadMonitor);
                }
            }
            for (String extension : checksums.keySet()) {
                ChecksumObserver observer = (ChecksumObserver)checksums.get(extension);
                sums.put(extension, observer.getActualChecksum());
            }
            for (String extension : checksums.keySet()) {
                File temp = File.createTempFile("maven-artifact", null);
                temp.deleteOnExit();
                FileUtils.fileWrite((String)temp.getAbsolutePath(), (String)"UTF-8", (String)((String)sums.get(extension)));
                wagon.put(temp, remotePath + "." + extension);
            }
        }
        catch (ConnectionException e) {
            throw new TransferFailedException("Connection failed: " + e.getMessage(), (Throwable)e);
        }
        catch (AuthenticationException e) {
            throw new TransferFailedException("Authentication failed: " + e.getMessage(), (Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new TransferFailedException("Authorization failed: " + e.getMessage(), (Throwable)e);
        }
        catch (ResourceDoesNotExistException e) {
            throw new TransferFailedException("Resource to deploy not found: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error creating temporary file for deployment: " + e.getMessage(), (Throwable)e);
        }
        finally {
            for (String aCHECKSUM_IDS : CHECKSUM_IDS) {
                TransferListener checksumListener = (TransferListener)checksums.get(aCHECKSUM_IDS);
                if (checksumListener == null) continue;
                wagon.removeTransferListener(checksumListener);
            }
            this.disconnectWagon(wagon);
            this.releaseWagon(protocol, wagon);
        }
    }

    private ChecksumObserver addChecksumObserver(Wagon wagon, String algorithm) throws TransferFailedException {
        try {
            ChecksumObserver checksumObserver = new ChecksumObserver(algorithm);
            wagon.addTransferListener((TransferListener)checksumObserver);
            return checksumObserver;
        }
        catch (NoSuchAlgorithmException e) {
            throw new TransferFailedException("Unable to add checksum for unsupported algorithm " + algorithm, (Throwable)e);
        }
    }

    private void handleChecksumFailure(String checksumPolicy, String message, Throwable cause) throws ChecksumFailedException {
        if ("fail".equals(checksumPolicy)) {
            throw new ChecksumFailedException(message, cause);
        }
        if (!"ignore".equals(checksumPolicy)) {
            this.logger.warn("*** CHECKSUM FAILED - " + message + " - IGNORING");
        }
    }

    private void verifyChecksum(ChecksumObserver checksumObserver, File destination, File tempDestination, String remotePath, String checksumFileExtension, Wagon wagon) throws ResourceDoesNotExistException, TransferFailedException, AuthorizationException {
        try {
            File checksumFile;
            String actualChecksum = checksumObserver.getActualChecksum();
            File tempChecksumFile = new File(tempDestination + checksumFileExtension + ".tmp");
            tempChecksumFile.deleteOnExit();
            wagon.get(remotePath + checksumFileExtension, tempChecksumFile);
            String expectedChecksum = FileUtils.fileRead((File)tempChecksumFile, (String)"UTF-8");
            expectedChecksum = expectedChecksum.trim();
            if (expectedChecksum.regionMatches(true, 0, "MD", 0, 2) || expectedChecksum.regionMatches(true, 0, "SHA", 0, 3)) {
                int lastSpacePos = expectedChecksum.lastIndexOf(32);
                expectedChecksum = expectedChecksum.substring(lastSpacePos + 1);
            } else {
                int spacePos = expectedChecksum.indexOf(32);
                if (spacePos != -1) {
                    expectedChecksum = expectedChecksum.substring(0, spacePos);
                }
            }
            if (expectedChecksum.equalsIgnoreCase(actualChecksum)) {
                checksumFile = new File(destination + checksumFileExtension);
                if (checksumFile.exists()) {
                    checksumFile.delete();
                }
            } else {
                throw new ChecksumFailedException("Checksum failed on download: local = '" + actualChecksum + "'; remote = '" + expectedChecksum + "'");
            }
            FileUtils.copyFile((File)tempChecksumFile, (File)checksumFile);
            tempChecksumFile.delete();
        }
        catch (IOException e) {
            throw new ChecksumFailedException("Invalid checksum file", e);
        }
    }

    private void disconnectWagon(Wagon wagon) {
        try {
            wagon.disconnect();
        }
        catch (ConnectionException e) {
            this.logger.error("Problem disconnecting from wagon - ignoring: " + e.getMessage());
        }
    }

    private void releaseWagon(String protocol, Wagon wagon) {
        try {
            this.container.release((Object)wagon);
        }
        catch (ComponentLifecycleException e) {
            this.logger.error("Problem releasing wagon - ignoring: " + e.getMessage());
            this.logger.debug("", (Throwable)e);
        }
    }

    @Override
    @Deprecated
    public Wagon getWagon(Repository repository) throws UnsupportedProtocolException {
        return this.getWagon(repository.getProtocol());
    }

    @Override
    @Deprecated
    public Wagon getWagon(String protocol) throws UnsupportedProtocolException {
        if (protocol == null) {
            throw new UnsupportedProtocolException("Unspecified protocol");
        }
        String hint = protocol.toLowerCase(Locale.ENGLISH);
        Wagon wagon = this.wagons.get(hint);
        if (wagon == null) {
            throw new UnsupportedProtocolException("Cannot find wagon which supports the requested protocol: " + protocol);
        }
        return wagon;
    }
}

