/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.installer;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataInstallationException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.repository.DefaultLocalRepositoryMaintainerEvent;
import org.apache.maven.repository.LocalRepositoryMaintainer;
import org.apache.maven.repository.LocalRepositoryMaintainerEvent;
import org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformationManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;

@Component(role=ArtifactInstaller.class)
public class DefaultArtifactInstaller
extends AbstractLogEnabled
implements ArtifactInstaller {
    @Requirement
    private ArtifactTransformationManager transformationManager;
    @Requirement
    private RepositoryMetadataManager repositoryMetadataManager;
    @Requirement(optional=true)
    private LocalRepositoryMaintainer localRepositoryMaintainer;

    @Deprecated
    public void install(String basedir, String finalName, Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        String extension = artifact.getArtifactHandler().getExtension();
        File source = new File(basedir, finalName + "." + extension);
        this.install(source, artifact, localRepository);
    }

    public void install(File source, Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        try {
            boolean copy;
            this.transformationManager.transformForInstall(artifact, localRepository);
            String localPath = localRepository.pathOf(artifact);
            File destination = new File(localRepository.getBasedir(), localPath);
            if (!destination.getParentFile().exists()) {
                destination.getParentFile().mkdirs();
            }
            boolean bl = copy = !destination.exists() || "pom".equals(artifact.getType()) || source.lastModified() != destination.lastModified() || source.length() != destination.length();
            if (copy) {
                this.getLogger().info("Installing " + source + " to " + destination);
                FileUtils.copyFile((File)source, (File)destination);
                destination.setLastModified(source.lastModified());
            } else {
                this.getLogger().info("Skipped re-installing " + source + " to " + destination + ", seems unchanged");
            }
            for (ArtifactMetadata metadata : artifact.getMetadataList()) {
                this.repositoryMetadataManager.install(metadata, localRepository);
            }
            if (this.localRepositoryMaintainer != null) {
                DefaultLocalRepositoryMaintainerEvent event = new DefaultLocalRepositoryMaintainerEvent(localRepository, artifact, destination);
                this.localRepositoryMaintainer.artifactInstalled((LocalRepositoryMaintainerEvent)event);
            }
        }
        catch (IOException e) {
            throw new ArtifactInstallationException("Error installing artifact: " + e.getMessage(), e);
        }
        catch (RepositoryMetadataInstallationException e) {
            throw new ArtifactInstallationException("Error installing artifact's metadata: " + e.getMessage(), e);
        }
    }
}

