/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.repository.Proxy;
import org.apache.maven.wagon.repository.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DefaultArtifactRepository
extends Repository
implements ArtifactRepository {
    private ArtifactRepositoryLayout layout;
    private ArtifactRepositoryPolicy snapshots;
    private ArtifactRepositoryPolicy releases;
    private boolean blacklisted;
    private Authentication authentication;
    private Proxy proxy;

    public DefaultArtifactRepository(String id, String url, ArtifactRepositoryLayout layout) {
        this(id, url, layout, null, null);
    }

    public DefaultArtifactRepository(String id, String url, ArtifactRepositoryLayout layout, boolean uniqueVersion) {
        super(id, url);
        this.layout = layout;
    }

    public DefaultArtifactRepository(String id, String url, ArtifactRepositoryLayout layout, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) {
        super(id, url);
        this.layout = layout;
        if (snapshots == null) {
            snapshots = new ArtifactRepositoryPolicy(true, "always", "ignore");
        }
        this.snapshots = snapshots;
        if (releases == null) {
            releases = new ArtifactRepositoryPolicy(true, "always", "ignore");
        }
        this.releases = releases;
    }

    public String pathOf(Artifact artifact) {
        return this.layout.pathOf(artifact);
    }

    public String pathOfRemoteRepositoryMetadata(ArtifactMetadata artifactMetadata) {
        return this.layout.pathOfRemoteRepositoryMetadata(artifactMetadata);
    }

    public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
        return this.layout.pathOfLocalRepositoryMetadata(metadata, repository);
    }

    public void setLayout(ArtifactRepositoryLayout layout) {
        this.layout = layout;
    }

    public ArtifactRepositoryLayout getLayout() {
        return this.layout;
    }

    public void setSnapshotUpdatePolicy(ArtifactRepositoryPolicy snapshots) {
        this.snapshots = snapshots;
    }

    public ArtifactRepositoryPolicy getSnapshots() {
        return this.snapshots;
    }

    public void setReleaseUpdatePolicy(ArtifactRepositoryPolicy releases) {
        this.releases = releases;
    }

    public ArtifactRepositoryPolicy getReleases() {
        return this.releases;
    }

    public String getKey() {
        return this.getId();
    }

    public boolean isBlacklisted() {
        return this.blacklisted;
    }

    public void setBlacklisted(boolean blacklisted) {
        this.blacklisted = blacklisted;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("       id: ").append(this.getId()).append("\n");
        sb.append("      url: ").append(this.getUrl()).append("\n");
        sb.append("   layout: ").append(this.layout != null ? this.layout.getId() : "none").append("\n");
        if (this.snapshots != null) {
            sb.append("snapshots: [enabled => ").append(this.snapshots.isEnabled());
            sb.append(", update => ").append(this.snapshots.getUpdatePolicy()).append("]\n");
        }
        if (this.releases != null) {
            sb.append(" releases: [enabled => ").append(this.releases.isEnabled());
            sb.append(", update => ").append(this.releases.getUpdatePolicy()).append("]\n");
        }
        return sb.toString();
    }

    public Artifact find(Artifact artifact) {
        File artifactFile = new File(this.getBasedir(), this.pathOf(artifact));
        artifact.setFile(artifactFile);
        if (artifactFile.exists()) {
            artifact.setResolved(true);
        }
        return artifact;
    }

    public List<String> findVersions(Artifact artifact) {
        return Collections.emptyList();
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public boolean isUniqueVersion() {
        return true;
    }
}

