/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.di.impl;

import java.lang.annotation.Annotation;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.di.impl.ReflectionUtils;

public final class Utils {
    public static String getDisplayString(Class<? extends Annotation> annotationType, @Nullable Annotation annotation) {
        if (annotation == null) {
            return "@" + ReflectionUtils.getDisplayName(annotationType);
        }
        String typeName = annotationType.getName();
        String str = annotation.toString();
        return str.startsWith("@" + typeName) ? "@" + ReflectionUtils.getDisplayName(annotationType) + str.substring(typeName.length() + 1) : str;
    }

    public static String getDisplayString(Object object) {
        if (object instanceof Class && ((Class)object).isAnnotation()) {
            return Utils.getDisplayString((Class)object, null);
        }
        if (object instanceof Annotation) {
            Annotation annotation = (Annotation)object;
            return Utils.getDisplayString(annotation.annotationType(), annotation);
        }
        return object.toString();
    }

    public static boolean isMarker(Class<? extends Annotation> annotationType) {
        return annotationType.getDeclaredMethods().length == 0;
    }
}

