/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.jxr.JxrException;
import org.apache.maven.jxr.pacman.ClassType;
import org.apache.maven.jxr.pacman.PackageManager;
import org.apache.maven.jxr.pacman.PackageType;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class DirectoryIndexer {
    static final String INDEX = "package-summary.html";
    private String root;
    private PackageManager packageManager;
    private String outputEncoding;
    private String templateDir;
    private String windowTitle;
    private String docTitle;
    private String bottom;

    public DirectoryIndexer(PackageManager packageManager, String root) {
        this.packageManager = packageManager;
        this.root = root;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    public void setWindowTitle(String windowTitle) {
        this.windowTitle = windowTitle;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public void setDocTitle(String docTitle) {
        this.docTitle = docTitle;
    }

    public String getDocTitle() {
        return this.docTitle;
    }

    public void setBottom(String bottom) {
        this.bottom = bottom;
    }

    public String getBottom() {
        return this.bottom;
    }

    public void process() throws JxrException {
        ProjectInfo info = this.getProjectInfo();
        VelocityEngine engine = new VelocityEngine();
        this.setProperties(engine);
        try {
            engine.init();
        }
        catch (Exception e) {
            throw new JxrException("Error initializing Velocity", e);
        }
        VelocityContext context = new VelocityContext();
        context.put("outputEncoding", (Object)this.getOutputEncoding());
        context.put("windowTitle", (Object)this.getWindowTitle());
        context.put("docTitle", (Object)this.getDocTitle());
        context.put("bottom", (Object)this.getBottom());
        context.put("info", (Object)info);
        this.doVelocity("index", this.root, context, engine);
        this.doVelocity("overview-frame", this.root, context, engine);
        this.doVelocity("allclasses-frame", this.root, context, engine);
        this.doVelocity("overview-summary", this.root, context, engine);
        for (PackageInfo pkgInfo : info.getAllPackages().values()) {
            VelocityContext subContext = new VelocityContext((Context)context);
            subContext.put("pkgInfo", (Object)pkgInfo);
            String outDir = this.root + '/' + pkgInfo.getDir();
            this.doVelocity("package-summary", outDir, subContext, engine);
            this.doVelocity("package-frame", outDir, subContext, engine);
        }
    }

    private void setProperties(VelocityEngine engine) {
        Path templateDirFile = Paths.get(this.getTemplateDir(), new String[0]);
        if (templateDirFile.isAbsolute()) {
            engine.setProperty("resource.loaders", (Object)"file");
            engine.setProperty("resource.loader.file.class", (Object)"org.apache.velocity.runtime.resource.loader.FileResourceLoader");
            engine.setProperty("resource.loader.file.path", (Object)templateDirFile.toString());
        } else {
            engine.setProperty("resource.loaders", (Object)"classpath");
            engine.setProperty("resource.loader.classpath.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        }
    }

    private void doVelocity(String templateName, String outDir, VelocityContext context, VelocityEngine engine) throws JxrException {
        File file = new File(outDir, templateName + ".html");
        file.getParentFile().mkdirs();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getOutputEncoding());){
            StringBuilder templateFile = new StringBuilder();
            File templateDirFile = new File(this.getTemplateDir());
            if (!templateDirFile.isAbsolute()) {
                templateFile.append(this.getTemplateDir());
                templateFile.append('/');
            }
            templateFile.append(templateName);
            templateFile.append(".vm");
            Template template = engine.getTemplate(templateFile.toString());
            template.merge((Context)context, (Writer)writer);
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            throw new JxrException("Error merging velocity template", e);
        }
    }

    ProjectInfo getProjectInfo() {
        TreeMap<String, PackageInfo> allPackages = new TreeMap<String, PackageInfo>();
        TreeMap<String, ClassInfo> allClasses = new TreeMap<String, ClassInfo>();
        for (PackageType pkg : this.packageManager.getPackageTypes()) {
            String pkgName = pkg.getName();
            String pkgDir = pkgName.replace('.', '/');
            String rootRef = pkgName.replaceAll("[^\\.]+(\\.|$)", "../");
            if (pkgName.length() == 0) {
                pkgName = "(default package)";
                pkgDir = ".";
                rootRef = "./";
            }
            TreeMap<String, ClassInfo> pkgClasses = new TreeMap<String, ClassInfo>();
            for (ClassType clazz : pkg.getClassTypes()) {
                String className = clazz.getName();
                ClassInfo classInfo = new ClassInfo(className, pkgDir);
                classInfo.setFilename(clazz.getFilename());
                pkgClasses.put(className, classInfo);
                allClasses.put(className + "#" + pkgName, classInfo);
            }
            PackageInfo pkgInfo = new PackageInfo(pkgName, pkgDir);
            pkgInfo.setClasses(pkgClasses);
            pkgInfo.setRootRef(rootRef);
            allPackages.put(pkgName, pkgInfo);
        }
        return new ProjectInfo(allPackages, allClasses);
    }

    public static class ClassInfo {
        private final String name;
        private final String dir;
        private String filename;

        public ClassInfo(String name, String dir) {
            this.name = name;
            this.dir = dir;
        }

        public String getName() {
            return this.name;
        }

        public String getDir() {
            return this.dir;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }
    }

    public static class PackageInfo {
        private final String name;
        private final String dir;
        Map<String, ClassInfo> classes;
        private String rootRef;

        public PackageInfo(String name, String dir) {
            this.name = name;
            this.dir = dir;
        }

        public String getName() {
            return this.name;
        }

        public String getDir() {
            return this.dir;
        }

        public void setClasses(Map<String, ClassInfo> classes) {
            this.classes = classes;
        }

        public Map<String, ClassInfo> getClasses() {
            return this.classes;
        }

        public void setRootRef(String rootRef) {
            this.rootRef = rootRef;
        }

        public String getRootRef() {
            return this.rootRef;
        }
    }

    public static class ProjectInfo {
        private final Map<String, PackageInfo> allPackages;
        private final Map<String, ClassInfo> allClasses;

        public ProjectInfo(Map<String, PackageInfo> allPackages, Map<String, ClassInfo> allClasses) {
            this.allPackages = allPackages;
            this.allClasses = allClasses;
        }

        public Map<String, PackageInfo> getAllPackages() {
            return this.allPackages;
        }

        public Map<String, ClassInfo> getAllClasses() {
            return this.allClasses;
        }
    }
}

