/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.clover;

import com.cenqua.clover.cfg.Percentage;
import com.cenqua.clover.tasks.CloverPassTask;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.clover.internal.AbstractCloverMojo;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class CloverCheckMojo
extends AbstractCloverMojo {
    private String targetPercentage;

    public void execute() throws MojoExecutionException {
        if (!this.isInCloverForkedLifecycle()) {
            if (this.areCloverDatabasesAvailable()) {
                super.execute();
                AbstractCloverMojo.waitForFlush(this.getWaitForFlush(), this.getFlushInterval());
                this.check();
            } else {
                this.getLog().info((CharSequence)"No Clover database found, skipping test coverage verification");
            }
        }
    }

    private void check() throws MojoExecutionException {
        if (new File(this.getCloverDatabase()).exists()) {
            this.checkDatabase(this.getCloverDatabase());
        }
        if (new File(this.getCloverMergeDatabase()).exists()) {
            this.checkDatabase(this.getCloverMergeDatabase());
        }
    }

    private void checkDatabase(String database) throws MojoExecutionException {
        Project antProject = AbstractCloverMojo.registerCloverAntTasks();
        this.getLog().info((CharSequence)("Checking for coverage of [" + this.targetPercentage + "] for database [" + database + "]"));
        CloverPassTask cloverPassTask = (CloverPassTask)antProject.createTask("clover-check");
        cloverPassTask.setInitString(database);
        cloverPassTask.setHaltOnFailure(true);
        cloverPassTask.setTarget(new Percentage(this.targetPercentage));
        cloverPassTask.setFailureProperty("clovercheckproperty");
        try {
            cloverPassTask.execute();
        }
        catch (BuildException e) {
            this.getLog().error((CharSequence)antProject.getProperty("clovercheckproperty"));
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private boolean isInCloverForkedLifecycle() {
        return this.getProject().getBuild().getDirectory().endsWith("clover");
    }
}

