/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.clover;

import com.cenqua.clover.CloverMerge;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.clover.internal.AbstractCloverMojo;
import org.apache.maven.project.MavenProject;

public class CloverAggregateMojo
extends AbstractCloverMojo {
    private List reactorProjects;

    public void execute() throws MojoExecutionException {
        if (this.getProject().getModules().size() > 0) {
            super.execute();
            AbstractCloverMojo.waitForFlush(this.getWaitForFlush(), this.getFlushInterval());
            if (this.getChildrenCloverDatabases().size() > 0) {
                new File(this.getCloverMergeDatabase()).getParentFile().mkdirs();
                this.mergeCloverDatabases();
            } else {
                this.getLog().warn((CharSequence)"No Clover databases found in children projects - No merge done");
            }
        }
    }

    private List getChildrenCloverDatabases() {
        String relativeCloverDatabasePath = this.getCloverDatabase().substring(this.getProject().getBasedir().getPath().length());
        ArrayList<String> dbFiles = new ArrayList<String>();
        Iterator projects = this.reactorProjects.iterator();
        while (projects.hasNext()) {
            MavenProject project = (MavenProject)projects.next();
            File cloverDb = new File(project.getBasedir(), relativeCloverDatabasePath);
            if (cloverDb.exists()) {
                dbFiles.add(cloverDb.getPath());
                continue;
            }
            this.getLog().debug((CharSequence)("Skipping [" + cloverDb.getPath() + "] as it doesn't exist."));
        }
        return dbFiles;
    }

    private void mergeCloverDatabases() throws MojoExecutionException {
        List dbFiles = this.getChildrenCloverDatabases();
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-i");
        parameters.add(this.getCloverMergeDatabase());
        if (this.getLog().isDebugEnabled()) {
            parameters.add("-d");
        }
        parameters.addAll(dbFiles);
        int mergeResult = CloverMerge.mainImpl((String[])parameters.toArray(new String[0]));
        if (mergeResult != 0) {
            throw new MojoExecutionException("Clover has failed to merge the children module databases");
        }
    }
}

