/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pdf;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.doxia.document.DocumentAuthor;
import org.apache.maven.doxia.document.DocumentCover;
import org.apache.maven.doxia.document.DocumentMeta;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.model.Developer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class DocumentModelBuilder {
    private final MavenProject project;
    private final DecorationModel decorationModel;

    public DocumentModelBuilder(MavenProject project) {
        this(project, null);
    }

    public DocumentModelBuilder(MavenProject project, DecorationModel decorationModel) {
        this.project = project;
        this.decorationModel = decorationModel;
    }

    public DocumentModel getDocumentModel() {
        return DocumentModelBuilder.getDocumentModel(this.project, this.decorationModel, null);
    }

    public DocumentModel getDocumentModel(Date date) {
        return DocumentModelBuilder.getDocumentModel(this.project, this.decorationModel, date);
    }

    private static DocumentModel getDocumentModel(MavenProject project, DecorationModel decorationModel, Date date) {
        Date now = date == null ? new Date() : date;
        DocumentModel docModel = new DocumentModel();
        docModel.setModelEncoding(DocumentModelBuilder.getProjectModelEncoding(project));
        docModel.setOutputName(project == null || project.getArtifactId() == null ? "unnamed" : project.getArtifactId());
        docModel.setMeta(DocumentModelBuilder.getDocumentMeta(project, now));
        docModel.setCover(DocumentModelBuilder.getDocumentCover(project, now));
        docModel.setToc(DocumentModelBuilder.getDocumentTOC(decorationModel));
        return docModel;
    }

    private static DocumentTOC getDocumentTOC(DecorationModel decorationModel) {
        DocumentTOC toc = new DocumentTOC();
        if (decorationModel != null && decorationModel.getMenus() != null) {
            Iterator it = decorationModel.getMenus().iterator();
            while (it.hasNext()) {
                Menu menu = (Menu)it.next();
                Iterator it2 = menu.getItems().iterator();
                while (it2.hasNext()) {
                    MenuItem item = (MenuItem)it2.next();
                    DocumentTOCItem documentTOCItem = new DocumentTOCItem();
                    documentTOCItem.setName(item.getName());
                    documentTOCItem.setRef(item.getHref());
                    toc.addItem(documentTOCItem);
                }
            }
        }
        return toc;
    }

    private static DocumentMeta getDocumentMeta(MavenProject project, Date date) {
        DocumentMeta meta = new DocumentMeta();
        meta.setAuthors(DocumentModelBuilder.getAuthors(project));
        meta.setCreationDate(date);
        meta.setCreator(System.getProperty("user.name"));
        meta.setDate(date);
        meta.setDescription(project == null ? null : project.getDescription());
        meta.setInitialCreator(System.getProperty("user.name"));
        meta.setSubject(DocumentModelBuilder.getProjectName(project));
        meta.setTitle(DocumentModelBuilder.getProjectName(project));
        return meta;
    }

    private static DocumentCover getDocumentCover(MavenProject project, Date date) {
        DocumentCover cover = new DocumentCover();
        cover.setAuthors(DocumentModelBuilder.getAuthors(project));
        cover.setCompanyName(DocumentModelBuilder.getProjectOrganizationName(project));
        cover.setCoverDate(date);
        cover.setCoverSubTitle(project == null ? null : "v. " + project.getVersion());
        cover.setCoverTitle(DocumentModelBuilder.getProjectName(project));
        cover.setCoverVersion(project == null ? null : project.getVersion());
        cover.setProjectName(DocumentModelBuilder.getProjectName(project));
        return cover;
    }

    private static List getAuthors(MavenProject project) {
        if (project == null || project.getDevelopers() == null) {
            return null;
        }
        ArrayList<DocumentAuthor> ret = new ArrayList<DocumentAuthor>();
        Iterator it = project.getDevelopers().iterator();
        while (it.hasNext()) {
            Developer developer = (Developer)it.next();
            DocumentAuthor author = new DocumentAuthor();
            author.setName(developer.getName());
            author.setEmail(developer.getEmail());
            author.setCompanyName(developer.getOrganization());
            StringBuffer roles = null;
            Iterator it2 = developer.getRoles().iterator();
            while (it2.hasNext()) {
                String role = (String)it2.next();
                if (roles == null) {
                    roles = new StringBuffer();
                }
                roles.append(role);
                if (!it2.hasNext()) continue;
                roles.append(',').append(' ');
            }
            if (roles != null) {
                author.setPosition(roles.toString());
            }
            ret.add(author);
        }
        return ret;
    }

    private static String getProjectOrganizationName(MavenProject project) {
        if (project != null && project.getOrganization() != null && StringUtils.isNotEmpty((String)project.getOrganization().getName())) {
            return project.getOrganization().getName();
        }
        return System.getProperty("user.name");
    }

    private static String getProjectName(MavenProject project) {
        if (project == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)project.getName())) {
            return project.getGroupId() + ":" + project.getArtifactId();
        }
        return project.getName();
    }

    private static String getProjectModelEncoding(MavenProject project) {
        if (project == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)project.getModel().getModelEncoding())) {
            return "UTF-8";
        }
        return project.getModel().getModelEncoding();
    }
}

