/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pdf;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.docrenderer.DocumentRenderer;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.docrenderer.pdf.PdfRenderer;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.io.xpp3.DocumentXpp3Writer;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Reader;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.pdf.DocumentDescriptorReader;
import org.apache.maven.plugins.pdf.DocumentModelBuilder;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PdfMojo
extends AbstractMojo {
    private PdfRenderer foRenderer;
    private I18N i18n;
    private PdfRenderer itextRenderer;
    private String locales;
    private Renderer siteRenderer;
    private SiteTool siteTool;
    private MavenProject project;
    private File siteDirectory;
    private File outputDirectory;
    private File workingDirectory;
    private File docDescriptor;
    private String implementation;
    private ArtifactRepository localRepository;
    private boolean aggregate;
    private DocumentRenderer docRenderer;
    private Locale defaultLocale;
    private DecorationModel defaultDecorationModel;
    private String pluginVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("fo".equals(this.implementation)) {
            this.docRenderer = this.foRenderer;
        } else if ("itext".equals(this.implementation)) {
            this.docRenderer = this.itextRenderer;
        } else {
            throw new MojoFailureException("Not a valid implementation: " + this.implementation);
        }
        try {
            List localesList = this.siteTool.getAvailableLocales(this.locales);
            this.defaultLocale = (Locale)localesList.get(0);
            Locale.setDefault(this.defaultLocale);
            Iterator iterator = localesList.iterator();
            while (iterator.hasNext()) {
                Locale locale = (Locale)iterator.next();
                File workingDir = this.getWorkingDirectory(locale);
                File siteDirectoryFile = this.siteDirectory;
                if (!locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
                    siteDirectoryFile = new File(this.siteDirectory, locale.getLanguage());
                }
                this.copyResources(locale);
                try {
                    if (this.aggregate) {
                        this.docRenderer.render(siteDirectoryFile, workingDir, this.getDocumentModel(locale));
                        continue;
                    }
                    this.docRenderer.render(siteDirectoryFile, workingDir, null);
                }
                catch (DocumentRendererException e) {
                    throw new MojoExecutionException("Error during document generation", (Exception)((Object)e));
                }
            }
            if (!this.outputDirectory.getCanonicalPath().equals(this.workingDirectory.getCanonicalPath())) {
                List pdfs = FileUtils.getFiles((File)this.workingDirectory, (String)"**/*.pdf", null);
                Iterator it = pdfs.iterator();
                while (it.hasNext()) {
                    File pdf = (File)it.next();
                    FileUtils.copyFile((File)pdf, (File)new File(this.outputDirectory, pdf.getName()));
                    pdf.delete();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during document generation", (Exception)e);
        }
    }

    private DocumentModel getDocumentModel(Locale locale) throws MojoExecutionException {
        if (this.docDescriptor.exists()) {
            DocumentModel doc = this.getDocumentModelFromDescriptor(locale);
            return doc;
        }
        DocumentModel model = new DocumentModelBuilder(this.project, this.getDefaultDecorationModel()).getDocumentModel();
        model.getMeta().setGenerator(this.getDefaultGenerator());
        model.getMeta().setLanguage(locale.getLanguage());
        model.getCover().setCoverType(this.i18n.getString("pdf-plugin", this.defaultLocale, "toc.type"));
        model.getToc().setName(this.i18n.getString("pdf-plugin", this.defaultLocale, "toc.title"));
        this.debugLogGeneratedModel(model);
        return model;
    }

    private DocumentModel getDocumentModelFromDescriptor(Locale locale) throws MojoExecutionException {
        DocumentModel model = null;
        try {
            model = new DocumentDescriptorReader(this.project, this.getLog()).readAndFilterDocumentDescriptor(this.docDescriptor);
        }
        catch (XmlPullParserException ex) {
            throw new MojoExecutionException("Error reading DocumentDescriptor!", (Exception)((Object)ex));
        }
        catch (IOException io) {
            throw new MojoExecutionException("Error opening DocumentDescriptor!", (Exception)io);
        }
        if (StringUtils.isEmpty((String)model.getMeta().getLanguage())) {
            model.getMeta().setLanguage(locale.getLanguage());
        }
        if (StringUtils.isEmpty((String)model.getMeta().getGenerator())) {
            model.getMeta().setGenerator(this.getDefaultGenerator());
        }
        return model;
    }

    private File getWorkingDirectory(Locale locale) {
        if (locale.getLanguage().equals(this.defaultLocale.getLanguage())) {
            return this.workingDirectory;
        }
        return new File(this.workingDirectory, locale.getLanguage());
    }

    private Locale getDefaultLocale() {
        if (this.defaultLocale == null) {
            List localesList = this.siteTool.getAvailableLocales(this.locales);
            this.defaultLocale = (Locale)localesList.get(0);
        }
        return this.defaultLocale;
    }

    private DecorationModel getDefaultDecorationModel() throws MojoExecutionException {
        if (this.defaultDecorationModel == null) {
            Locale locale = this.getDefaultLocale();
            File basedir = this.project.getBasedir();
            String relativePath = this.siteTool.getRelativePath(this.siteDirectory.getAbsolutePath(), basedir.getAbsolutePath());
            File descriptorFile = this.siteTool.getSiteDescriptorFromBasedir(relativePath, basedir, locale);
            DecorationModel decoration = null;
            if (descriptorFile.exists()) {
                XmlStreamReader reader = null;
                try {
                    reader = ReaderFactory.newXmlReader((File)descriptorFile);
                    String siteDescriptorContent = IOUtil.toString((Reader)reader);
                    siteDescriptorContent = this.siteTool.getInterpolatedSiteDescriptorContent(new HashMap(), this.project, siteDescriptorContent, reader.getEncoding(), reader.getEncoding());
                    decoration = new DecorationXpp3Reader().read((Reader)new StringReader(siteDescriptorContent));
                }
                catch (XmlPullParserException e) {
                    throw new MojoExecutionException("Error parsing site descriptor", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading site descriptor", (Exception)e);
                }
                catch (SiteToolException e) {
                    throw new MojoExecutionException("Error when interpoling site descriptor", (Exception)((Object)e));
                }
                finally {
                    IOUtil.close((Reader)reader);
                }
            }
            this.defaultDecorationModel = decoration;
        }
        return this.defaultDecorationModel;
    }

    private void copyResources(Locale locale) throws MojoExecutionException {
        File skinFile;
        DecorationModel decorationModel = this.getDefaultDecorationModel();
        if (decorationModel == null) {
            return;
        }
        try {
            skinFile = this.siteTool.getSkinArtifactFromRepository(this.localRepository, this.project.getRemoteArtifactRepositories(), decorationModel).getFile();
        }
        catch (SiteToolException e) {
            throw new MojoExecutionException("SiteToolException: " + e.getMessage(), (Exception)((Object)e));
        }
        if (skinFile == null) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Copy resources from skin artifact: '" + skinFile + "'..."));
        }
        try {
            SiteRenderingContext context = this.siteRenderer.createContextForSkin(skinFile, new HashMap(), decorationModel, this.project.getName(), locale);
            context.addSiteDirectory(new File(this.siteDirectory, locale.getLanguage()));
            Iterator i = context.getSiteDirectories().iterator();
            while (i.hasNext()) {
                File siteDirectoryFile = (File)i.next();
                this.siteRenderer.copyResources(context, new File(siteDirectoryFile, "resources"), this.workingDirectory);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException: " + e.getMessage(), (Exception)e);
        }
    }

    private String getDefaultGenerator() {
        return "Maven PDF Plugin v. " + this.pluginVersion + ", '" + this.implementation + "' implementation.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugLogGeneratedModel(DocumentModel docModel) {
        if (this.getLog().isDebugEnabled() && this.project != null) {
            File outputDir = new File(this.project.getBuild().getDirectory(), "pdf");
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            File doc = FileUtils.createTempFile((String)"pdf", (String)".xml", (File)outputDir);
            DocumentXpp3Writer xpp3 = new DocumentXpp3Writer();
            XmlStreamWriter w = null;
            try {
                w = WriterFactory.newXmlWriter((File)doc);
                xpp3.write((Writer)w, docModel);
                this.getLog().debug((CharSequence)("Generated a default document model: " + doc.getAbsolutePath()));
            }
            catch (IOException io) {
                this.getLog().debug((CharSequence)("Failed to write document model: " + doc.getAbsolutePath()), (Throwable)io);
            }
            finally {
                IOUtil.close((Writer)w);
            }
        }
    }
}

