/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.util.Iterator;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractPmdReport
extends AbstractMavenReport {
    protected File targetDirectory;
    protected String outputDirectory;
    private SiteRenderer siteRenderer;
    protected MavenProject project;
    protected String format = "xml";
    private boolean linkXRef;
    private File xrefLocation;

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String constructXRefLocation() {
        String location = null;
        if (this.linkXRef) {
            String relativePath = PathTool.getRelativePath((String)this.outputDirectory, (String)this.xrefLocation.getAbsolutePath());
            if (StringUtils.isEmpty((String)relativePath)) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + this.xrefLocation.getName();
            if (this.xrefLocation.exists()) {
                location = relativePath;
            } else {
                Iterator reports = this.project.getReportPlugins().iterator();
                while (reports.hasNext()) {
                    ReportPlugin plugin = (ReportPlugin)reports.next();
                    String artifactId = plugin.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    location = relativePath;
                }
            }
            if (location == null) {
                this.getLog().warn((CharSequence)"Unable to locate Source XRef to link to - DISABLED");
            }
        }
        return location;
    }

    protected boolean isHtml() {
        return "html".equals(this.format);
    }

    public boolean canGenerateReport() {
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        return "java".equals(artifactHandler.getLanguage()) && new File(this.project.getBuild().getSourceDirectory()).exists();
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }
}

