/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractPmdViolationCheckMojo
extends AbstractMojo {
    private File targetDirectory;
    private boolean failOnViolation;
    private String language;
    private File sourceDirectory;

    protected void executeCheck(String filename, String tagName, String key) throws MojoFailureException, MojoExecutionException {
        block6: {
            if ("java".equals(this.language) && this.sourceDirectory.exists()) {
                File outputFile = new File(this.targetDirectory, filename);
                if (outputFile.exists()) {
                    try {
                        MXParser xpp = new MXParser();
                        FileReader freader = new FileReader(outputFile);
                        BufferedReader breader = new BufferedReader(freader);
                        xpp.setInput((Reader)breader);
                        int violations = this.countViolations((XmlPullParser)xpp, tagName);
                        if (violations > 0 && this.failOnViolation) {
                            throw new MojoFailureException("You have " + violations + " " + key + (violations > 1 ? "s" : "") + ".");
                        }
                        break block6;
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Unable to read PMD results xml: " + outputFile.getAbsolutePath(), (Exception)e);
                    }
                    catch (XmlPullParserException e) {
                        throw new MojoExecutionException("Unable to read PMD results xml: " + outputFile.getAbsolutePath(), (Exception)((Object)e));
                    }
                }
                throw new MojoFailureException("Unable to perform check, unable to find " + outputFile);
            }
        }
    }

    private int countViolations(XmlPullParser xpp, String tagName) throws XmlPullParserException, IOException {
        int count = 0;
        int eventType = xpp.getEventType();
        while (eventType != 1) {
            if (eventType == 2 && tagName.equals(xpp.getName())) {
                ++count;
            }
            eventType = xpp.next();
        }
        return count;
    }
}

