/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.JavaLanguage;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import org.apache.maven.plugin.pmd.AbstractPmdReport;
import org.apache.maven.plugin.pmd.CpdReportGenerator;
import org.apache.maven.reporting.MavenReportException;

public class CpdReport
extends AbstractPmdReport {
    private int minimumTokens;
    static /* synthetic */ Class class$org$apache$maven$plugin$pmd$CpdReport;

    public String getName(Locale locale) {
        return CpdReport.getBundle(locale).getString("report.cpd.name");
    }

    public String getDescription(Locale locale) {
        return CpdReport.getBundle(locale).getString("report.cpd.description");
    }

    public void executeReport(Locale locale) throws MavenReportException {
        if (this.canGenerateReport()) {
            CPD cpd = new CPD(this.minimumTokens, (Language)new JavaLanguage());
            String src = this.getProject().getBuild().getSourceDirectory();
            try {
                cpd.addRecursively(src);
            }
            catch (IOException e) {
                throw new MavenReportException(e.getMessage(), (Exception)e);
            }
            cpd.go();
            CpdReportGenerator gen = new CpdReportGenerator(this.getSink(), src, CpdReport.getBundle(locale), this.constructXRefLocation());
            gen.generate(cpd.getMatches());
            if (!this.isHtml()) {
                Renderer r = this.createRenderer();
                String buffer = r.render(cpd.getMatches());
                try {
                    this.targetDirectory.mkdirs();
                    FileWriter writer = new FileWriter(new File(this.targetDirectory, "cpd." + this.format));
                    ((Writer)writer).write(buffer, 0, buffer.length());
                    ((Writer)writer).close();
                }
                catch (IOException ioe) {
                    throw new MavenReportException(ioe.getMessage(), (Exception)ioe);
                }
            }
        }
    }

    public String getOutputName() {
        return "cpd";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("cpd-report", locale, (class$org$apache$maven$plugin$pmd$CpdReport == null ? (class$org$apache$maven$plugin$pmd$CpdReport = CpdReport.class$("org.apache.maven.plugin.pmd.CpdReport")) : class$org$apache$maven$plugin$pmd$CpdReport).getClassLoader());
    }

    public Renderer createRenderer() throws MavenReportException {
        XMLRenderer renderer = null;
        if ("xml".equals(this.format)) {
            renderer = new XMLRenderer();
        } else if ("csv".equals(this.format)) {
            renderer = new CSVRenderer();
        } else if (!"".equals(this.format) && !"none".equals(this.format)) {
            try {
                renderer = (Renderer)Class.forName(this.format).newInstance();
            }
            catch (Exception e) {
                throw new MavenReportException("Can't find the custom format " + this.format + ": " + e.getClass().getName());
            }
        }
        if (renderer == null) {
            throw new MavenReportException("Can't create report with format of " + this.format);
        }
        return renderer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

