/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.util.Iterator;
import java.util.ResourceBundle;
import net.sourceforge.pmd.cpd.Match;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;

public class CpdReportGenerator {
    private Sink sink;
    private String sourceDirectory;
    private ResourceBundle bundle;
    private String xrefLocation;

    public CpdReportGenerator(Sink sink, String sourceDirectory, ResourceBundle bundle, String xrefLocation) {
        this.sink = sink;
        this.sourceDirectory = sourceDirectory;
        this.bundle = bundle;
        this.xrefLocation = xrefLocation;
    }

    private String getTitle() {
        return this.bundle.getString("report.cpd.title");
    }

    public void beginDocument() {
        this.sink.head();
        this.sink.title();
        this.sink.text(this.getTitle());
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getTitle());
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.bundle.getString("report.cpd.cpdlink") + " ");
        this.sink.link("http://pmd.sourceforge.net/cpd.html");
        this.sink.text("CPD");
        this.sink.link_();
        this.sink.paragraph_();
        this.sink.section1_();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.cpd.dupes"));
        this.sink.sectionTitle1_();
    }

    public void generate(Iterator matches) {
        this.beginDocument();
        while (matches.hasNext()) {
            Match match = (Match)matches.next();
            String filename1 = match.getFirstMark().getTokenSrcID();
            filename1 = StringUtils.substring((String)filename1, (int)(this.sourceDirectory.length() + 1));
            String filename2 = match.getSecondMark().getTokenSrcID();
            filename2 = StringUtils.substring((String)filename2, (int)(this.sourceDirectory.length() + 1));
            String code = match.getSourceCodeSlice();
            int line1 = match.getFirstMark().getBeginLine();
            int line2 = match.getSecondMark().getBeginLine();
            this.sink.paragraph();
            this.sink.table();
            this.sink.tableRow();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.cpd.column.file"));
            this.sink.tableHeaderCell_();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.cpd.column.line"));
            this.sink.tableHeaderCell_();
            this.sink.tableRow_();
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.text(filename1);
            this.sink.tableCell_();
            this.sink.tableCell();
            if (this.xrefLocation != null) {
                this.sink.link(this.xrefLocation + "/" + filename1.replaceAll("\\.java$", ".html").replace('\\', '/') + "#" + line1);
            }
            this.sink.text(String.valueOf(line1));
            if (this.xrefLocation != null) {
                this.sink.link_();
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.text(filename2);
            this.sink.tableCell_();
            this.sink.tableCell();
            if (this.xrefLocation != null) {
                this.sink.link(this.xrefLocation + "/" + filename2.replaceAll("\\.java$", ".html").replace('\\', '/') + "#" + line2);
            }
            this.sink.text(String.valueOf(line2));
            if (this.xrefLocation != null) {
                this.sink.link_();
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
            this.sink.tableRow();
            this.sink.rawText("<td colspan='2'>");
            this.sink.verbatim(false);
            this.sink.text(code);
            this.sink.verbatim_();
            this.sink.rawText("</td>");
            this.sink.tableRow_();
            this.sink.table();
            this.sink.paragraph_();
        }
        this.sink.section1_();
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }
}

