/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.ReportListener;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.TargetJDK1_3;
import net.sourceforge.pmd.TargetJDK1_4;
import net.sourceforge.pmd.TargetJDK1_5;
import net.sourceforge.pmd.TargetJDKVersion;
import net.sourceforge.pmd.renderers.CSVRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.renderers.XMLRenderer;
import org.apache.maven.plugin.pmd.AbstractPmdReport;
import org.apache.maven.plugin.pmd.Locator;
import org.apache.maven.plugin.pmd.PmdReportListener;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class PmdReport
extends AbstractPmdReport {
    private String targetJdk;
    private String[] rulesets = new String[]{"rulesets/basic.xml", "rulesets/unusedcode.xml", "rulesets/imports.xml"};
    private String sourceEncoding;
    private String[] excludes;
    static /* synthetic */ Class class$org$apache$maven$plugin$pmd$PmdReport;

    public String getName(Locale locale) {
        return PmdReport.getBundle(locale).getString("report.pmd.name");
    }

    public String getDescription(Locale locale) {
        return PmdReport.getBundle(locale).getString("report.pmd.description");
    }

    public void executeReport(Locale locale) throws MavenReportException {
        if (this.canGenerateReport()) {
            List files;
            Sink sink = this.getSink();
            PMD pmd = this.getPMD();
            RuleContext ruleContext = new RuleContext();
            Report report = new Report();
            String sourceDirectory = this.project.getBuild().getSourceDirectory();
            PmdReportListener reportSink = new PmdReportListener(sink, sourceDirectory, PmdReport.getBundle(locale));
            String location = this.constructXRefLocation();
            if (location != null) {
                reportSink.setXrefLocation(location);
            }
            report.addListener((ReportListener)reportSink);
            ruleContext.setReport(report);
            reportSink.beginDocument();
            try {
                files = this.getFilesToProcess("**/*.java", this.getExclusionsString(this.excludes));
            }
            catch (IOException e) {
                throw new MavenReportException("Can't parse " + sourceDirectory, (Exception)e);
            }
            Locator locator = new Locator(this.getLog());
            RuleSetFactory ruleSetFactory = new RuleSetFactory();
            RuleSet[] sets = new RuleSet[this.rulesets.length];
            try {
                for (int idx = 0; idx < this.rulesets.length; ++idx) {
                    String set = this.rulesets[idx];
                    this.getLog().debug((CharSequence)("Preparing ruleset: " + set));
                    File ruleset = locator.resolveLocation(set, this.getLocationTemp(set));
                    FileInputStream rulesInput = new FileInputStream(ruleset);
                    sets[idx] = ruleSetFactory.createRuleSet((InputStream)rulesInput);
                }
            }
            catch (IOException e) {
                throw new MavenReportException(e.getMessage(), (Exception)e);
            }
            boolean hasEncoding = this.sourceEncoding != null;
            Iterator i = files.iterator();
            while (i.hasNext()) {
                File file = (File)i.next();
                try {
                    reportSink.beginFile(file);
                    ruleContext.setSourceCodeFilename(file.getAbsolutePath());
                    for (int idx = 0; idx < this.rulesets.length; ++idx) {
                        try {
                            InputStreamReader reader = hasEncoding ? new InputStreamReader((InputStream)new FileInputStream(file), this.sourceEncoding) : new FileReader(file);
                            pmd.processFile((Reader)reader, sets[idx], ruleContext);
                            continue;
                        }
                        catch (UnsupportedEncodingException e1) {
                            throw new MavenReportException("Encoding '" + this.sourceEncoding + "' is not supported.", (Exception)e1);
                        }
                    }
                    reportSink.endFile(file);
                }
                catch (PMDException e) {
                    Throwable ex = e;
                    if (e.getReason() != null) {
                        ex = e.getReason();
                    }
                    throw new MavenReportException("Failure executing PMD for: " + file, (Exception)ex);
                }
                catch (FileNotFoundException e) {
                    throw new MavenReportException("Error opening source file: " + file, (Exception)e);
                }
            }
            reportSink.endDocument();
            if (!this.isHtml()) {
                Renderer r = this.createRenderer();
                String buffer = r.render(report);
                try {
                    FileWriter writer = new FileWriter(new File(this.targetDirectory, "pmd." + this.format));
                    ((Writer)writer).write(buffer, 0, buffer.length());
                    ((Writer)writer).close();
                }
                catch (IOException ioe) {
                    throw new MavenReportException(ioe.getMessage(), (Exception)ioe);
                }
            }
        }
    }

    private String getLocationTemp(String name) {
        String loc = name;
        if (loc.indexOf(47) != -1) {
            loc = loc.substring(loc.lastIndexOf(47) + 1);
        }
        if (loc.indexOf(92) != -1) {
            loc = loc.substring(loc.lastIndexOf(92) + 1);
        }
        this.getLog().debug((CharSequence)("Before: " + name + " After: " + loc));
        return this.project.getBuild().getDirectory() + File.separator + loc;
    }

    public PMD getPMD() {
        PMD pmd = "1.5".equals(this.targetJdk) ? new PMD((TargetJDKVersion)new TargetJDK1_5()) : ("1.4".equals(this.targetJdk) ? new PMD((TargetJDKVersion)new TargetJDK1_4()) : ("1.3".equals(this.targetJdk) ? new PMD((TargetJDKVersion)new TargetJDK1_3()) : new PMD()));
        return pmd;
    }

    public String getOutputName() {
        return "pmd";
    }

    private List getFilesToProcess(String includes, String excludes) throws IOException {
        List files = Collections.EMPTY_LIST;
        File dir = new File(this.project.getBuild().getSourceDirectory());
        if (dir.exists()) {
            StringBuffer excludesStr = new StringBuffer();
            if (StringUtils.isNotEmpty((String)excludes)) {
                excludesStr.append(excludes);
            }
            String[] defaultExcludes = FileUtils.getDefaultExcludes();
            for (int i = 0; i < defaultExcludes.length; ++i) {
                if (excludesStr.length() > 0) {
                    excludesStr.append(",");
                }
                excludesStr.append(defaultExcludes[i]);
            }
            this.getLog().debug((CharSequence)("Excluded files: '" + excludesStr + "'"));
            files = FileUtils.getFiles((File)dir, (String)includes, (String)excludesStr.toString());
        }
        return files;
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("pmd-report", locale, (class$org$apache$maven$plugin$pmd$PmdReport == null ? (class$org$apache$maven$plugin$pmd$PmdReport = PmdReport.class$("org.apache.maven.plugin.pmd.PmdReport")) : class$org$apache$maven$plugin$pmd$PmdReport).getClassLoader());
    }

    private String getExclusionsString(String[] exclude) {
        StringBuffer excludes = new StringBuffer();
        if (exclude != null) {
            for (int index = 0; index < exclude.length; ++index) {
                if (excludes.length() > 0) {
                    excludes.append(',');
                }
                excludes.append(exclude[index]);
            }
        }
        return excludes.toString();
    }

    public final Renderer createRenderer() throws MavenReportException {
        XMLRenderer renderer = null;
        if ("xml".equals(this.format)) {
            renderer = new XMLRenderer();
        } else if ("txt".equals(this.format)) {
            renderer = new TextRenderer();
        } else if ("csv".equals(this.format)) {
            renderer = new CSVRenderer();
        } else if ("html".equals(this.format)) {
            renderer = new HTMLRenderer();
        } else if (!"".equals(this.format) && !"none".equals(this.format)) {
            try {
                renderer = (Renderer)Class.forName(this.format).newInstance();
            }
            catch (Exception e) {
                throw new MavenReportException("Can't find the custom format " + this.format + ": " + e.getClass().getName());
            }
        }
        if (renderer == null) {
            throw new MavenReportException("Can't create report with format of " + this.format);
        }
        return renderer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

