/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import net.sourceforge.pmd.ReportListener;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.stat.Metric;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;

public class PmdReportListener
implements ReportListener {
    private Sink sink;
    private String sourceDirectory;
    private String currentFilename;
    private boolean fileInitialized;
    private ResourceBundle bundle;
    private String xrefLocation;
    private List violations = new ArrayList();
    private List metrics = new ArrayList();

    public PmdReportListener(Sink sink, String sourceDirectory, ResourceBundle bundle) {
        this.sink = sink;
        this.sourceDirectory = sourceDirectory;
        this.bundle = bundle;
    }

    private String getTitle() {
        return this.bundle.getString("report.pmd.title");
    }

    public void ruleViolationAdded(RuleViolation ruleViolation) {
        if (!this.fileInitialized) {
            this.sink.section2();
            this.sink.sectionTitle2();
            this.sink.text(this.currentFilename);
            this.sink.sectionTitle2_();
            this.sink.table();
            this.sink.tableRow();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.pmd.column.violation"));
            this.sink.tableHeaderCell_();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.pmd.column.line"));
            this.sink.tableHeaderCell_();
            this.sink.tableRow_();
            this.fileInitialized = true;
        }
        this.violations.add(ruleViolation);
    }

    private void processViolations() {
        Collections.sort(this.violations, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((RuleViolation)o1).getBeginLine() - ((RuleViolation)o2).getBeginLine();
            }
        });
        Iterator it = this.violations.iterator();
        while (it.hasNext()) {
            RuleViolation ruleViolation = (RuleViolation)it.next();
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.text(ruleViolation.getDescription());
            this.sink.tableCell_();
            this.sink.tableCell();
            int beginLine = ruleViolation.getBeginLine();
            this.outputLineLink(beginLine);
            int endLine = ruleViolation.getEndLine();
            if (endLine != beginLine) {
                this.sink.text(" - ");
                this.outputLineLink(endLine);
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.violations.clear();
    }

    private void outputLineLink(int line) {
        if (this.xrefLocation != null) {
            this.sink.link(this.xrefLocation + "/" + this.currentFilename.replaceAll("\\.java$", ".html") + "#" + line);
        }
        this.sink.text(String.valueOf(line));
        if (this.xrefLocation != null) {
            this.sink.link_();
        }
    }

    public void metricAdded(Metric metric) {
        if (metric.getCount() != 0) {
            this.metrics.add(metric);
        }
    }

    public void beginDocument() {
        this.sink.head();
        this.sink.title();
        this.sink.text(this.getTitle());
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getTitle());
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.bundle.getString("report.pmd.pmdlink") + " ");
        this.sink.link("http://pmd.sourceforge.net/");
        this.sink.text("PMD");
        this.sink.link_();
        this.sink.paragraph_();
        this.sink.section1_();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.pmd.files"));
        this.sink.sectionTitle1_();
    }

    public void beginFile(File file) {
        this.currentFilename = StringUtils.substring((String)file.getAbsolutePath(), (int)(this.sourceDirectory.length() + 1));
        this.currentFilename = StringUtils.replace((String)this.currentFilename, (String)"\\", (String)"/");
        this.fileInitialized = false;
    }

    public void endFile(File file) {
        if (this.fileInitialized) {
            this.processViolations();
            this.sink.table_();
            this.sink.section2_();
        }
    }

    public void endDocument() {
        this.sink.section1_();
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }

    public String getXrefLocation() {
        return this.xrefLocation;
    }

    public void setXrefLocation(String xrefLocation) {
        this.xrefLocation = xrefLocation;
    }
}

