/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import net.sourceforge.pmd.cpd.Match;
import org.apache.maven.plugin.pmd.PmdFileInfo;
import org.apache.maven.project.MavenProject;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;

public class CpdReportGenerator {
    private Sink sink;
    private Map fileMap;
    private ResourceBundle bundle;
    private boolean aggregate;

    public CpdReportGenerator(Sink sink, Map fileMap, ResourceBundle bundle, boolean aggregate) {
        this.sink = sink;
        this.fileMap = fileMap;
        this.bundle = bundle;
        this.aggregate = aggregate;
    }

    private String getTitle() {
        return this.bundle.getString("report.cpd.title");
    }

    public void beginDocument() {
        this.sink.head();
        this.sink.title();
        this.sink.text(this.getTitle());
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getTitle());
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.bundle.getString("report.cpd.cpdlink") + " ");
        this.sink.link("http://pmd.sourceforge.net/cpd.html");
        this.sink.text("CPD");
        this.sink.link_();
        this.sink.text(" 4.1.");
        this.sink.paragraph_();
        this.sink.section1_();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.cpd.dupes"));
        this.sink.sectionTitle1_();
    }

    public void generate(Iterator matches) {
        this.beginDocument();
        if (!matches.hasNext()) {
            this.sink.text("CPD found no problems in your source code.");
        }
        while (matches.hasNext()) {
            Match match = (Match)matches.next();
            String filename1 = match.getFirstMark().getTokenSrcID();
            File file = new File(filename1);
            PmdFileInfo fileInfo = (PmdFileInfo)this.fileMap.get(file);
            File sourceDirectory = fileInfo.getSourceDirectory();
            String xrefLocation = fileInfo.getXrefLocation();
            MavenProject projectFile1 = fileInfo.getProject();
            filename1 = StringUtils.substring((String)filename1, (int)(sourceDirectory.getAbsolutePath().length() + 1));
            String filename2 = match.getSecondMark().getTokenSrcID();
            file = new File(filename2);
            fileInfo = (PmdFileInfo)this.fileMap.get(file);
            sourceDirectory = fileInfo.getSourceDirectory();
            String xrefLocation2 = fileInfo.getXrefLocation();
            filename2 = StringUtils.substring((String)filename2, (int)(sourceDirectory.getAbsolutePath().length() + 1));
            MavenProject projectFile2 = fileInfo.getProject();
            String code = match.getSourceCodeSlice();
            int line1 = match.getFirstMark().getBeginLine();
            int line2 = match.getSecondMark().getBeginLine();
            this.sink.paragraph();
            this.sink.table();
            this.sink.tableRow();
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.cpd.column.file"));
            this.sink.tableHeaderCell_();
            if (this.aggregate) {
                this.sink.tableHeaderCell();
                this.sink.text(this.bundle.getString("report.cpd.column.project"));
                this.sink.tableHeaderCell_();
            }
            this.sink.tableHeaderCell();
            this.sink.text(this.bundle.getString("report.cpd.column.line"));
            this.sink.tableHeaderCell_();
            this.sink.tableRow_();
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.text(filename1);
            this.sink.tableCell_();
            if (this.aggregate) {
                this.sink.tableCell();
                this.sink.text(projectFile1.getName());
                this.sink.tableCell_();
            }
            this.sink.tableCell();
            if (xrefLocation != null) {
                this.sink.link(xrefLocation + "/" + filename1.replaceAll("\\.java$", ".html").replace('\\', '/') + "#" + line1);
            }
            this.sink.text(String.valueOf(line1));
            if (xrefLocation != null) {
                this.sink.link_();
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.text(filename2);
            this.sink.tableCell_();
            if (this.aggregate) {
                this.sink.tableCell();
                this.sink.text(projectFile2.getName());
                this.sink.tableCell_();
            }
            this.sink.tableCell();
            if (xrefLocation != null) {
                this.sink.link(xrefLocation2 + "/" + filename2.replaceAll("\\.java$", ".html").replace('\\', '/') + "#" + line2);
            }
            this.sink.text(String.valueOf(line2));
            if (xrefLocation != null) {
                this.sink.link_();
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
            this.sink.tableRow();
            int colspan = 2;
            if (this.aggregate) {
                ++colspan;
            }
            this.sink.rawText("<td colspan='" + colspan + "'>");
            this.sink.verbatim(false);
            this.sink.text(code);
            this.sink.verbatim_();
            this.sink.rawText("</td>");
            this.sink.tableRow_();
            this.sink.table();
            this.sink.paragraph_();
        }
        this.sink.section1_();
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }
}

