/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.ReportListener;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.renderers.CSVRenderer;
import net.sourceforge.pmd.renderers.HTMLRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.renderers.XMLRenderer;
import org.apache.maven.plugin.pmd.AbstractPmdReport;
import org.apache.maven.plugin.pmd.PmdFileInfo;
import org.apache.maven.plugin.pmd.PmdReportListener;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;

public class PmdReport
extends AbstractPmdReport {
    private String targetJdk;
    private int minimumPriority = 5;
    private boolean skip;
    private String[] rulesets = new String[]{"rulesets/basic.xml", "rulesets/unusedcode.xml", "rulesets/imports.xml"};
    private String sourceEncoding;
    private ResourceManager locator;

    public String getName(Locale locale) {
        return PmdReport.getBundle(locale).getString("report.pmd.name");
    }

    public String getDescription(Locale locale) {
        return PmdReport.getBundle(locale).getString("report.pmd.description");
    }

    public void setRulesets(String[] rules) {
        this.rulesets = rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeReport(Locale locale) throws MavenReportException {
        block22: {
            this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
            this.locator.addSearchPath("url", "");
            this.locator.setOutputDirectory(new File(this.project.getBuild().getDirectory()));
            if (!this.skip && this.canGenerateReport()) {
                ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Map files;
                    Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                    Sink sink = this.getSink();
                    PMD pmd = this.getPMD();
                    RuleContext ruleContext = new RuleContext();
                    Report report = new Report();
                    PmdReportListener reportSink = new PmdReportListener(sink, PmdReport.getBundle(locale), this.aggregate);
                    report.addListener((ReportListener)reportSink);
                    ruleContext.setReport(report);
                    reportSink.beginDocument();
                    RuleSetFactory ruleSetFactory = new RuleSetFactory();
                    ruleSetFactory.setMinimumPriority(this.minimumPriority);
                    RuleSet[] sets = new RuleSet[this.rulesets.length];
                    try {
                        for (int idx = 0; idx < this.rulesets.length; ++idx) {
                            String set = this.rulesets[idx];
                            this.getLog().debug((CharSequence)("Preparing ruleset: " + set));
                            File ruleset = null;
                            ruleset = this.locator.getResourceAsFile(set, this.getLocationTemp(set));
                            if (null == ruleset) {
                                throw new MavenReportException("Could not resolve " + set);
                            }
                            FileInputStream rulesInput = new FileInputStream(ruleset);
                            sets[idx] = ruleSetFactory.createRuleSet((InputStream)rulesInput);
                        }
                    }
                    catch (IOException e) {
                        throw new MavenReportException(e.getMessage(), (Exception)e);
                    }
                    catch (ResourceNotFoundException e) {
                        throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
                    }
                    catch (FileResourceCreationException e) {
                        throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
                    }
                    boolean hasEncoding = this.sourceEncoding != null;
                    try {
                        files = this.getFilesToProcess();
                    }
                    catch (IOException e) {
                        throw new MavenReportException("Can't get file list", (Exception)e);
                    }
                    Iterator i = files.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        File file = (File)entry.getKey();
                        PmdFileInfo fileInfo = (PmdFileInfo)entry.getValue();
                        reportSink.beginFile(file, fileInfo);
                        ruleContext.setSourceCodeFilename(file.getAbsolutePath());
                        for (int idx = 0; idx < this.rulesets.length; ++idx) {
                            try {
                                InputStreamReader reader = hasEncoding ? new InputStreamReader((InputStream)new FileInputStream(file), this.sourceEncoding) : new FileReader(file);
                                pmd.processFile((Reader)reader, sets[idx], ruleContext);
                                continue;
                            }
                            catch (UnsupportedEncodingException e1) {
                                throw new MavenReportException("Encoding '" + this.sourceEncoding + "' is not supported.", (Exception)e1);
                            }
                            catch (PMDException pe) {
                                String msg = pe.getLocalizedMessage();
                                Exception r = pe.getReason();
                                if (r != null) {
                                    msg = msg + ": " + r.getLocalizedMessage();
                                }
                                this.getLog().warn((CharSequence)msg);
                                reportSink.ruleViolationAdded(new ProcessingErrorRuleViolation(file, msg));
                                continue;
                            }
                            catch (FileNotFoundException e2) {
                                this.getLog().warn((CharSequence)("Error opening source file: " + file));
                                reportSink.ruleViolationAdded(new ProcessingErrorRuleViolation(file, e2.getLocalizedMessage()));
                                continue;
                            }
                            catch (Exception e3) {
                                this.getLog().warn((CharSequence)("Failure executing PMD for: " + file), (Throwable)e3);
                                reportSink.ruleViolationAdded(new ProcessingErrorRuleViolation(file, e3.getLocalizedMessage()));
                            }
                        }
                        reportSink.endFile(file);
                    }
                    reportSink.endDocument();
                    if (this.isHtml()) break block22;
                    Renderer r = this.createRenderer();
                    StringWriter stringwriter = new StringWriter();
                    try {
                        r.setWriter((Writer)stringwriter);
                        r.start();
                        r.renderFileReport(report);
                        r.end();
                        String buffer = stringwriter.toString();
                        FileWriter writer = new FileWriter(new File(this.targetDirectory, "pmd." + this.format));
                        ((Writer)writer).write(buffer, 0, buffer.length());
                        ((Writer)writer).close();
                        File siteDir = new File(this.targetDirectory, "site");
                        siteDir.mkdirs();
                        writer = new FileWriter(new File(siteDir, "pmd." + this.format));
                        ((Writer)writer).write(buffer, 0, buffer.length());
                        ((Writer)writer).close();
                    }
                    catch (IOException ioe) {
                        throw new MavenReportException(ioe.getMessage(), (Exception)ioe);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(origLoader);
                }
            }
        }
    }

    private String getLocationTemp(String name) {
        String loc = name;
        if (loc.indexOf(47) != -1) {
            loc = loc.substring(loc.lastIndexOf(47) + 1);
        }
        if (loc.indexOf(92) != -1) {
            loc = loc.substring(loc.lastIndexOf(92) + 1);
        }
        this.getLog().debug((CharSequence)("Before: " + name + " After: " + loc));
        return loc;
    }

    public PMD getPMD() throws MavenReportException {
        PMD pmd = new PMD();
        if (null != this.targetJdk) {
            SourceType sourceType = SourceType.getSourceTypeForId((String)("java " + this.targetJdk));
            if (sourceType == null) {
                throw new MavenReportException("Unsupported targetJdk value '" + this.targetJdk + "'.");
            }
            pmd.setJavaVersion(sourceType);
        }
        return pmd;
    }

    public String getOutputName() {
        return "pmd";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("pmd-report", locale, PmdReport.class.getClassLoader());
    }

    public final Renderer createRenderer() throws MavenReportException {
        XMLRenderer renderer = null;
        if ("xml".equals(this.format)) {
            renderer = new XMLRenderer();
        } else if ("txt".equals(this.format)) {
            renderer = new TextRenderer();
        } else if ("csv".equals(this.format)) {
            renderer = new CSVRenderer();
        } else if ("html".equals(this.format)) {
            renderer = new HTMLRenderer();
        } else if (!"".equals(this.format) && !"none".equals(this.format)) {
            try {
                renderer = (Renderer)Class.forName(this.format).newInstance();
            }
            catch (Exception e) {
                throw new MavenReportException("Can't find the custom format " + this.format + ": " + e.getClass().getName());
            }
        }
        if (renderer == null) {
            throw new MavenReportException("Can't create report with format of " + this.format);
        }
        return renderer;
    }

    private static class ProcessingErrorRuleViolation
    implements IRuleViolation {
        private String filename;
        private String description;

        public ProcessingErrorRuleViolation(File file, String description) {
            this.filename = file.getPath();
            this.description = description;
        }

        public String getFilename() {
            return this.filename;
        }

        public int getBeginLine() {
            return 0;
        }

        public int getBeginColumn() {
            return 0;
        }

        public int getEndLine() {
            return 0;
        }

        public int getEndColumn() {
            return 0;
        }

        public Rule getRule() {
            return null;
        }

        public String getDescription() {
            return this.description;
        }

        public String getPackageName() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public String getClassName() {
            return null;
        }

        public boolean isSuppressed() {
            return false;
        }

        public String getVariableName() {
            return null;
        }
    }
}

