/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.csv;

import com.opencsv.CSVParserBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.RFC4180ParserBuilder;
import org.apache.metamodel.csv.CsvConfiguration;

class CsvParserBuilder {
    private final CSVParserBuilder _csvParserBuilder;
    private final RFC4180ParserBuilder _rfc4180ParserBuilder;

    CsvParserBuilder(CsvConfiguration csvConfiguration) {
        if (csvConfiguration.getEscapeChar() == csvConfiguration.getQuoteChar()) {
            this._csvParserBuilder = null;
            this._rfc4180ParserBuilder = new RFC4180ParserBuilder().withSeparator(csvConfiguration.getSeparatorChar()).withQuoteChar(csvConfiguration.getQuoteChar());
        } else {
            this._csvParserBuilder = new CSVParserBuilder().withSeparator(csvConfiguration.getSeparatorChar()).withQuoteChar(csvConfiguration.getQuoteChar()).withEscapeChar(csvConfiguration.getEscapeChar());
            this._rfc4180ParserBuilder = null;
        }
    }

    ICSVParser build() {
        if (this._csvParserBuilder == null) {
            return this._rfc4180ParserBuilder.build();
        }
        return this._csvParserBuilder.build();
    }
}

