/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.convert.DocumentConverter;
import org.apache.metamodel.data.CachingDataSetHeader;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DocumentSource;
import org.apache.metamodel.data.DocumentSourceDataSet;
import org.apache.metamodel.data.MaxRowsDataSet;
import org.apache.metamodel.data.MaxRowsDocumentSource;
import org.apache.metamodel.json.JsonDocumentSource;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.builder.DocumentSourceProvider;
import org.apache.metamodel.schema.builder.SchemaBuilder;
import org.apache.metamodel.schema.builder.SingleTableInferentialSchemaBuilder;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDataContext
extends QueryPostprocessDataContext
implements DocumentSourceProvider {
    private static final Logger logger = LoggerFactory.getLogger(JsonDataContext.class);
    private final Resource _resource;
    private final SchemaBuilder _schemaBuilder;

    public JsonDataContext(File file) {
        this((Resource)new FileResource(file));
    }

    public JsonDataContext(Resource resource) {
        this(resource, (SchemaBuilder)new SingleTableInferentialSchemaBuilder(resource));
    }

    public JsonDataContext(Resource resource, SchemaBuilder schemaBuilder) {
        super(false);
        this._resource = resource;
        this._schemaBuilder = schemaBuilder;
    }

    protected Schema getMainSchema() throws MetaModelException {
        this._schemaBuilder.offerSources((DocumentSourceProvider)this);
        return this._schemaBuilder.build();
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._schemaBuilder.getSchemaName();
    }

    protected DataSet materializeMainSchemaTable(Table table, List<Column> columns, int maxRows) {
        DocumentConverter documentConverter = this._schemaBuilder.getDocumentConverter(table);
        List selectItems = columns.stream().map(SelectItem::new).collect(Collectors.toList());
        CachingDataSetHeader header = new CachingDataSetHeader(selectItems);
        DocumentSource documentSource = this.getDocumentSourceForTable(table.getName());
        DocumentSourceDataSet dataSet = new DocumentSourceDataSet((DataSetHeader)header, documentSource, documentConverter);
        if (maxRows > 0) {
            dataSet = new MaxRowsDataSet((DataSet)dataSet, maxRows);
        }
        return dataSet;
    }

    private DocumentSource createDocumentSource() {
        InputStream inputStream = this._resource.read();
        try {
            MappingJsonFactory jsonFactory = new MappingJsonFactory();
            JsonParser parser = jsonFactory.createParser(inputStream);
            logger.debug("Created JSON parser for resource: {}", (Object)this._resource);
            return new JsonDocumentSource(parser, this._resource.getName());
        }
        catch (Exception e) {
            FileHelper.safeClose((Object[])new Object[]{inputStream});
            throw new MetaModelException("Unexpected error while creating JSON parser", e);
        }
    }

    public DocumentSource getMixedDocumentSourceForSampling() {
        return new MaxRowsDocumentSource(this.createDocumentSource(), 1000);
    }

    public DocumentSource getDocumentSourceForTable(String sourceCollectionName) {
        return this.createDocumentSource();
    }
}

