/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.salesforce;

import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.StatusCode;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.metamodel.AbstractUpdateCallback;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.create.TableCreationBuilder;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.drop.TableDropBuilder;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.salesforce.SalesforceDataContext;
import org.apache.metamodel.salesforce.SalesforceDeleteBuilder;
import org.apache.metamodel.salesforce.SalesforceInsertBuilder;
import org.apache.metamodel.salesforce.SalesforceUpdateBuilder;
import org.apache.metamodel.salesforce.SalesforceUtils;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.update.RowUpdationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SalesforceUpdateCallback
extends AbstractUpdateCallback
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(SalesforceUpdateCallback.class);
    private static final int INSERT_BATCH_SIZE = 100;
    private final PartnerConnection _connection;
    private final List<SObject> _pendingInserts;

    public SalesforceUpdateCallback(SalesforceDataContext dataContext, PartnerConnection connection) {
        super((DataContext)dataContext);
        this._connection = connection;
        this._pendingInserts = new ArrayList<SObject>();
    }

    public TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException("Table creation not supported for Salesforce.com.");
    }

    public boolean isDropTableSupported() {
        return false;
    }

    public boolean isCreateTableSupported() {
        return false;
    }

    public TableDropBuilder dropTable(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Table dropping not supported for Salesforce.com.");
    }

    public RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new SalesforceInsertBuilder(this, table);
    }

    public boolean isDeleteSupported() {
        return true;
    }

    public RowDeletionBuilder deleteFrom(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new SalesforceDeleteBuilder(this, table);
    }

    protected void delete(String[] ids) {
        this.flushInserts();
        try {
            this._connection.delete(ids);
        }
        catch (ConnectionException e) {
            throw SalesforceUtils.wrapException(e, "Failed to delete objects in Salesforce");
        }
    }

    private void flushInserts() {
        if (this._pendingInserts.isEmpty()) {
            return;
        }
        SObject[] objectsToInsert = this._pendingInserts.toArray(new SObject[this._pendingInserts.size()]);
        this._pendingInserts.clear();
        try {
            SaveResult[] saveResults = this._connection.create(objectsToInsert);
            this.checkSaveResults(saveResults, "insert");
        }
        catch (ConnectionException e) {
            throw SalesforceUtils.wrapException(e, "Failed to insert objects in Salesforce");
        }
    }

    private void checkSaveResults(SaveResult[] saveResults, String action) {
        int successes = 0;
        int errors = 0;
        Error firstError = null;
        for (SaveResult saveResult : saveResults) {
            boolean success = saveResult.getSuccess();
            if (success) {
                logger.debug("Successfully {}ed record with id={}", (Object)action, (Object)saveResult.getId());
                ++successes;
            } else {
                Error[] errorArray = saveResult.getErrors();
                if (!"insert".equals(action)) {
                    boolean onlyMalformedId = true;
                    Error[] errorArray2 = errorArray;
                    int n = errorArray2.length;
                    for (int i = 0; i < n; ++i) {
                        Error error = errorArray2[i];
                        if (StatusCode.MALFORMED_ID != error.getStatusCode()) {
                            onlyMalformedId = false;
                            break;
                        }
                        logger.debug("Encountered MALFORMED_ID error for {} action. Ignoring.", (Object)action);
                    }
                    if (onlyMalformedId) {
                        return;
                    }
                }
                ++errors;
                for (Error error : errorArray) {
                    if (firstError == null) {
                        firstError = error;
                    }
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("Error reported by Salesforce for {} operation: {} - {} - {}", new Object[]{action, error.getStatusCode(), error.getMessage(), Arrays.toString(error.getFields())});
                }
            }
            if (errors <= 0) continue;
            throw new IllegalStateException(errors + " out of " + (errors + successes) + " object(s) could not be " + action + "ed in Salesforce! The first error message was: '" + firstError.getMessage() + "' (" + firstError.getStatusCode() + "). see error log for further details.");
        }
    }

    public boolean isUpdateSupported() {
        return true;
    }

    public RowUpdationBuilder update(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new SalesforceUpdateBuilder(this, table);
    }

    protected void insert(SObject obj) {
        this._pendingInserts.add(obj);
        if (this._pendingInserts.size() >= 100) {
            this.flushInserts();
        }
    }

    protected void update(SObject[] sObjects) {
        this.flushInserts();
        try {
            SaveResult[] saveResults = this._connection.update(sObjects);
            this.checkSaveResults(saveResults, "update");
        }
        catch (ConnectionException e) {
            throw SalesforceUtils.wrapException(e, "Failed to update objects in Salesforce");
        }
    }

    @Override
    public void close() {
        this.flushInserts();
    }

    protected void buildIdList(List<String> idList, FilterItem whereItem) {
        if (whereItem.isCompoundFilter()) {
            FilterItem[] childItems;
            LogicalOperator logicalOperator = whereItem.getLogicalOperator();
            if (logicalOperator != LogicalOperator.OR) {
                throw new IllegalStateException("Salesforce only allows deletion of records by their specific IDs. Violated by operator between where items: " + whereItem);
            }
            for (FilterItem childItem : childItems = whereItem.getChildItems()) {
                this.buildIdList(idList, childItem);
            }
            return;
        }
        OperatorType operator = whereItem.getOperator();
        if (!OperatorType.EQUALS_TO.equals(operator) && !OperatorType.IN.equals(operator)) {
            throw new IllegalStateException("Salesforce only allows deletion of records by their specific IDs. Violated by operator in where item: " + whereItem);
        }
        SelectItem selectItem = whereItem.getSelectItem();
        Column column = selectItem.getColumn();
        Object operand = whereItem.getOperand();
        if (column == null || operand == null || selectItem.hasFunction()) {
            throw new IllegalStateException("Salesforce only allows deletion of records by their specific IDs. Violated by where item: " + whereItem);
        }
        if (!column.isPrimaryKey()) {
            throw new IllegalStateException("Salesforce only allows deletion of records by their specific IDs. Violated by where item: " + whereItem);
        }
        if (operand instanceof String) {
            idList.add((String)operand);
        } else if (operand instanceof List) {
            List list = (List)operand;
            for (Object object : list) {
                idList.add(object.toString());
            }
        } else if (operand instanceof String[]) {
            for (String str : (String[])operand) {
                idList.add(str);
            }
        } else {
            throw new IllegalStateException("Salesforce only allows deletion of records by their specific IDs. Violated by operand in where item: " + whereItem);
        }
    }
}

