/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.beats.handler;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.listen.dispatcher.AsyncChannelDispatcher;
import org.apache.nifi.processor.util.listen.event.Event;
import org.apache.nifi.processor.util.listen.event.EventFactory;
import org.apache.nifi.processor.util.listen.event.EventFactoryUtil;
import org.apache.nifi.processor.util.listen.event.EventQueue;
import org.apache.nifi.processor.util.listen.response.ChannelResponder;
import org.apache.nifi.processors.beats.frame.BeatsEncoder;
import org.apache.nifi.processors.beats.frame.BeatsFrame;

public class BeatsFrameHandler<E extends Event<SocketChannel>> {
    private final Charset charset;
    private final EventFactory<E> eventFactory;
    private final EventQueue<E> events;
    private final SelectionKey key;
    private final AsyncChannelDispatcher dispatcher;
    private final BeatsEncoder encoder;
    private final ComponentLog logger;
    public static final byte FRAME_WINDOWSIZE = 87;
    public static final byte FRAME_DATA = 68;
    public static final byte FRAME_COMPRESSED = 67;
    public static final byte FRAME_ACK = 65;
    public static final byte FRAME_JSON = 74;

    public BeatsFrameHandler(SelectionKey selectionKey, Charset charset, EventFactory<E> eventFactory, BlockingQueue<E> events, AsyncChannelDispatcher dispatcher, ComponentLog logger) {
        this.key = selectionKey;
        this.charset = charset;
        this.eventFactory = eventFactory;
        this.dispatcher = dispatcher;
        this.logger = logger;
        this.events = new EventQueue(events, logger);
        this.encoder = new BeatsEncoder();
    }

    public void handle(BeatsFrame frame, ChannelResponder<SocketChannel> responder, String sender) throws IOException, InterruptedException {
        Map metadata = EventFactoryUtil.createMapWithSender((String)sender.toString());
        metadata.put("beats.sequencenumber", String.valueOf(frame.getSeqNumber()));
        String line = "";
        if (frame.getFrameType() == 74) {
            Event event = this.eventFactory.create(frame.getPayload(), metadata, responder);
            this.events.offer(event);
        }
    }
}

