/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.provenance;

import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.nifi.web.api.dto.provenance.AttributeDTO;
import org.apache.nifi.web.api.dto.util.TimestampAdapter;

@XmlType(name="provenanceEvent")
public class ProvenanceEventDTO {
    private String id;
    private Long eventId;
    private Date eventTime;
    private Long eventDuration;
    private Long lineageDuration;
    private String eventType;
    private String flowFileUuid;
    private String fileSize;
    private Long fileSizeBytes;
    private String clusterNodeId;
    private String clusterNodeAddress;
    private String groupId;
    private String componentId;
    private String componentType;
    private String componentName;
    private String sourceSystemFlowFileId;
    private String alternateIdentifierUri;
    private Collection<AttributeDTO> attributes;
    private List<String> parentUuids;
    private List<String> childUuids;
    private String transitUri;
    private String relationship;
    private String details;
    private Boolean contentEqual;
    private Boolean inputContentAvailable;
    private String inputContentClaimSection;
    private String inputContentClaimContainer;
    private String inputContentClaimIdentifier;
    private Long inputContentClaimOffset;
    private String inputContentClaimFileSize;
    private Long inputContentClaimFileSizeBytes;
    private Boolean outputContentAvailable;
    private String outputContentClaimSection;
    private String outputContentClaimContainer;
    private String outputContentClaimIdentifier;
    private Long outputContentClaimOffset;
    private String outputContentClaimFileSize;
    private Long outputContentClaimFileSizeBytes;
    private Boolean replayAvailable;
    private String replayExplanation;
    private String sourceConnectionIdentifier;

    @ApiModelProperty(value="The event uuid.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="The event id. This is a one up number thats unique per node.")
    public Long getEventId() {
        return this.eventId;
    }

    public void setEventId(Long eventId) {
        this.eventId = eventId;
    }

    @XmlJavaTypeAdapter(value=TimestampAdapter.class)
    @ApiModelProperty(value="The timestamp of the event.")
    public Date getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    @ApiModelProperty(value="The uuid of the flowfile for the event.")
    public String getFlowFileUuid() {
        return this.flowFileUuid;
    }

    public void setFlowFileUuid(String flowFileUuid) {
        this.flowFileUuid = flowFileUuid;
    }

    @ApiModelProperty(value="The size of the flowfile for the event.")
    public String getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(String fileSize) {
        this.fileSize = fileSize;
    }

    @ApiModelProperty(value="The size of the flowfile in bytes for the event.")
    public Long getFileSizeBytes() {
        return this.fileSizeBytes;
    }

    public void setFileSizeBytes(Long fileSizeBytes) {
        this.fileSizeBytes = fileSizeBytes;
    }

    @ApiModelProperty(value="The type of the event.")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @ApiModelProperty(value="The attributes of the flowfile for the event.")
    public Collection<AttributeDTO> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<AttributeDTO> attributes) {
        this.attributes = attributes;
    }

    @ApiModelProperty(value="The id of the group that the component resides in. If the component is no longer in the flow, the group id will not be set.")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @ApiModelProperty(value="The id of the component that generated the event.")
    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    @ApiModelProperty(value="The name of the component that generated the event.")
    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    @ApiModelProperty(value="The type of the component that generated the event.")
    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    @ApiModelProperty(value="The source/destination system uri if the event was a RECEIVE/SEND.")
    public String getTransitUri() {
        return this.transitUri;
    }

    public void setTransitUri(String transitUri) {
        this.transitUri = transitUri;
    }

    @ApiModelProperty(value="The alternate identifier uri for the fileflow for the event.")
    public String getAlternateIdentifierUri() {
        return this.alternateIdentifierUri;
    }

    public void setAlternateIdentifierUri(String alternateIdentifierUri) {
        this.alternateIdentifierUri = alternateIdentifierUri;
    }

    @ApiModelProperty(value="The identifier for the node where the event originated.")
    public String getClusterNodeId() {
        return this.clusterNodeId;
    }

    public void setClusterNodeId(String clusterNodeId) {
        this.clusterNodeId = clusterNodeId;
    }

    @ApiModelProperty(value="The label for the node where the event originated.")
    public String getClusterNodeAddress() {
        return this.clusterNodeAddress;
    }

    public void setClusterNodeAddress(String clusterNodeAddress) {
        this.clusterNodeAddress = clusterNodeAddress;
    }

    @ApiModelProperty(value="The parent uuids for the event.")
    public List<String> getParentUuids() {
        return this.parentUuids;
    }

    public void setParentUuids(List<String> parentUuids) {
        this.parentUuids = parentUuids;
    }

    @ApiModelProperty(value="The child uuids for the event.")
    public List<String> getChildUuids() {
        return this.childUuids;
    }

    public void setChildUuids(List<String> childUuids) {
        this.childUuids = childUuids;
    }

    @ApiModelProperty(value="The event duration in milliseconds.")
    public Long getEventDuration() {
        return this.eventDuration;
    }

    public void setEventDuration(Long eventDuration) {
        this.eventDuration = eventDuration;
    }

    @ApiModelProperty(value="The duration since the lineage began, in milliseconds.")
    public Long getLineageDuration() {
        return this.lineageDuration;
    }

    public void setLineageDuration(Long lineageDuration) {
        this.lineageDuration = lineageDuration;
    }

    @ApiModelProperty(value="The source system flowfile id.")
    public String getSourceSystemFlowFileId() {
        return this.sourceSystemFlowFileId;
    }

    public void setSourceSystemFlowFileId(String sourceSystemFlowFileId) {
        this.sourceSystemFlowFileId = sourceSystemFlowFileId;
    }

    @ApiModelProperty(value="The relationship to which the flowfile was routed if the event is of type ROUTE.")
    public String getRelationship() {
        return this.relationship;
    }

    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    @ApiModelProperty(value="The event details.")
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    @ApiModelProperty(value="Whether the input and output content claim is the same.")
    public Boolean getContentEqual() {
        return this.contentEqual;
    }

    public void setContentEqual(Boolean contentEqual) {
        this.contentEqual = contentEqual;
    }

    @ApiModelProperty(value="Whether the output content is still available.")
    public Boolean getOutputContentAvailable() {
        return this.outputContentAvailable;
    }

    public void setOutputContentAvailable(Boolean outputContentAvailable) {
        this.outputContentAvailable = outputContentAvailable;
    }

    @ApiModelProperty(value="The section in which the output content claim lives.")
    public String getOutputContentClaimSection() {
        return this.outputContentClaimSection;
    }

    public void setOutputContentClaimSection(String contentClaimSection) {
        this.outputContentClaimSection = contentClaimSection;
    }

    @ApiModelProperty(value="The container in which the output content claim lives.")
    public String getOutputContentClaimContainer() {
        return this.outputContentClaimContainer;
    }

    public void setOutputContentClaimContainer(String outputContentClaimContainer) {
        this.outputContentClaimContainer = outputContentClaimContainer;
    }

    @ApiModelProperty(value="The identifier of the output content claim.")
    public String getOutputContentClaimIdentifier() {
        return this.outputContentClaimIdentifier;
    }

    public void setOutputContentClaimIdentifier(String outputContentClaimIdentifier) {
        this.outputContentClaimIdentifier = outputContentClaimIdentifier;
    }

    @ApiModelProperty(value="The offset into the output content claim where the flowfiles content begins.")
    public Long getOutputContentClaimOffset() {
        return this.outputContentClaimOffset;
    }

    public void setOutputContentClaimOffset(Long outputContentClaimOffset) {
        this.outputContentClaimOffset = outputContentClaimOffset;
    }

    @ApiModelProperty(value="The file size of the output content claim formatted.")
    public String getOutputContentClaimFileSize() {
        return this.outputContentClaimFileSize;
    }

    public void setOutputContentClaimFileSize(String outputContentClaimFileSize) {
        this.outputContentClaimFileSize = outputContentClaimFileSize;
    }

    @ApiModelProperty(value="The file size of the output content claim in bytes.")
    public Long getOutputContentClaimFileSizeBytes() {
        return this.outputContentClaimFileSizeBytes;
    }

    public void setOutputContentClaimFileSizeBytes(Long outputContentClaimFileSizeBytes) {
        this.outputContentClaimFileSizeBytes = outputContentClaimFileSizeBytes;
    }

    @ApiModelProperty(value="Whether the input content is still available.")
    public Boolean getInputContentAvailable() {
        return this.inputContentAvailable;
    }

    public void setInputContentAvailable(Boolean inputContentAvailable) {
        this.inputContentAvailable = inputContentAvailable;
    }

    @ApiModelProperty(value="The section in which the input content claim lives.")
    public String getInputContentClaimSection() {
        return this.inputContentClaimSection;
    }

    public void setInputContentClaimSection(String inputContentClaimSection) {
        this.inputContentClaimSection = inputContentClaimSection;
    }

    @ApiModelProperty(value="The container in which the input content claim lives.")
    public String getInputContentClaimContainer() {
        return this.inputContentClaimContainer;
    }

    public void setInputContentClaimContainer(String inputContentClaimContainer) {
        this.inputContentClaimContainer = inputContentClaimContainer;
    }

    @ApiModelProperty(value="The identifier of the input content claim.")
    public String getInputContentClaimIdentifier() {
        return this.inputContentClaimIdentifier;
    }

    public void setInputContentClaimIdentifier(String inputContentClaimIdentifier) {
        this.inputContentClaimIdentifier = inputContentClaimIdentifier;
    }

    @ApiModelProperty(value="The offset into the input content claim where the flowfiles content begins.")
    public Long getInputContentClaimOffset() {
        return this.inputContentClaimOffset;
    }

    public void setInputContentClaimOffset(Long inputContentClaimOffset) {
        this.inputContentClaimOffset = inputContentClaimOffset;
    }

    @ApiModelProperty(value="The file size of the input content claim formatted.")
    public String getInputContentClaimFileSize() {
        return this.inputContentClaimFileSize;
    }

    public void setInputContentClaimFileSize(String inputContentClaimFileSize) {
        this.inputContentClaimFileSize = inputContentClaimFileSize;
    }

    @ApiModelProperty(value="The file size of the intput content claim in bytes.")
    public Long getInputContentClaimFileSizeBytes() {
        return this.inputContentClaimFileSizeBytes;
    }

    public void setInputContentClaimFileSizeBytes(Long inputContentClaimFileSizeBytes) {
        this.inputContentClaimFileSizeBytes = inputContentClaimFileSizeBytes;
    }

    @ApiModelProperty(value="Whether or not replay is available.")
    public Boolean getReplayAvailable() {
        return this.replayAvailable;
    }

    public void setReplayAvailable(Boolean replayAvailable) {
        this.replayAvailable = replayAvailable;
    }

    @ApiModelProperty(value="Explanation as to why replay is unavailable.")
    public String getReplayExplanation() {
        return this.replayExplanation;
    }

    public void setReplayExplanation(String replayExplanation) {
        this.replayExplanation = replayExplanation;
    }

    @ApiModelProperty(value="The identifier of the queue/connection from which the flowfile was pulled to genereate this event. May be null if the queue/connection is unknown or the flowfile was generated from this event.")
    public String getSourceConnectionIdentifier() {
        return this.sourceConnectionIdentifier;
    }

    public void setSourceConnectionIdentifier(String sourceConnectionIdentifier) {
        this.sourceConnectionIdentifier = sourceConnectionIdentifier;
    }
}

