/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class TimezoneAdapter
extends XmlAdapter<String, Date> {
    public static final String DEFAULT_DATE_TIME_FORMAT = "z";

    public String marshal(Date date) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat(DEFAULT_DATE_TIME_FORMAT, Locale.US);
        formatter.setTimeZone(TimeZone.getDefault());
        return formatter.format(date);
    }

    public Date unmarshal(String date) throws Exception {
        SimpleDateFormat parser = new SimpleDateFormat(DEFAULT_DATE_TIME_FORMAT, Locale.US);
        parser.setTimeZone(TimeZone.getDefault());
        return parser.parse(date);
    }
}

