/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlType;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.entity.ControllerServiceReferencingComponentEntity;

@XmlType(name="controllerServiceReferencingComponent")
public class ControllerServiceReferencingComponentDTO {
    private String groupId;
    private String id;
    private String name;
    private String type;
    private String state;
    private Map<String, String> properties;
    private Map<String, PropertyDescriptorDTO> descriptors;
    private Collection<String> validationErrors;
    private String referenceType;
    private Integer activeThreadCount;
    private Boolean referenceCycle;
    private Set<ControllerServiceReferencingComponentEntity> referencingComponents;

    @ApiModelProperty(value="The group id for the component referencing a controller service. If this component is another controller service or a reporting task, this field is blank.")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @ApiModelProperty(value="The id of the component referencing a controller service.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="The name of the component referencing a controller service.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The type of the component referencing a controller service in simple Java class name format without package name.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ApiModelProperty(value="The scheduled state of a processor or reporting task referencing a controller service. If this component is another controller service, this field represents the controller service state.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @ApiModelProperty(value="The type of reference this is.", allowableValues="Processor, ControllerService, or ReportingTask")
    public String getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    @ApiModelProperty(value="The properties for the component.")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @ApiModelProperty(value="The descriptors for the component properties.")
    public Map<String, PropertyDescriptorDTO> getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(Map<String, PropertyDescriptorDTO> descriptors) {
        this.descriptors = descriptors;
    }

    @ApiModelProperty(value="The validation errors for the component.")
    public Collection<String> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(Collection<String> validationErrors) {
        this.validationErrors = validationErrors;
    }

    @ApiModelProperty(value="The number of active threads for the referencing component.")
    public Integer getActiveThreadCount() {
        return this.activeThreadCount;
    }

    public void setActiveThreadCount(Integer activeThreadCount) {
        this.activeThreadCount = activeThreadCount;
    }

    @ApiModelProperty(value="If the referencing component represents a controller service, these are the components that reference it.")
    public Set<ControllerServiceReferencingComponentEntity> getReferencingComponents() {
        return this.referencingComponents;
    }

    public void setReferencingComponents(Set<ControllerServiceReferencingComponentEntity> referencingComponents) {
        this.referencingComponents = referencingComponents;
    }

    @ApiModelProperty(value="If the referencing component represents a controller service, this indicates whether it has already been represented in this hierarchy.")
    public Boolean getReferenceCycle() {
        return this.referenceCycle;
    }

    public void setReferenceCycle(Boolean referenceCycle) {
        this.referenceCycle = referenceCycle;
    }
}

