/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.dbcp.DriverShim;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;

@Tags(value={"dbcp", "jdbc", "database", "connection", "pooling", "store"})
@CapabilityDescription(value="Provides Database Connection Pooling Service. Connections can be asked from pool and returned after usage.")
public class DBCPConnectionPool
extends AbstractControllerService
implements DBCPService {
    public static final PropertyDescriptor DATABASE_URL = new PropertyDescriptor.Builder().name("Database Connection URL").description("A database connection URL used to connect to a database. May contain database system name, host, port, database name and some parameters. The exact syntax of a database connection URL is specified by your DBMS.").defaultValue(null).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).build();
    public static final PropertyDescriptor DB_DRIVERNAME = new PropertyDescriptor.Builder().name("Database Driver Class Name").description("Database driver class name").defaultValue(null).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor DB_DRIVER_JAR_URL = new PropertyDescriptor.Builder().name("Database Driver Jar Url").description("Optional database driver jar file path url. For example 'file:///var/tmp/mariadb-java-client-1.1.7.jar'").defaultValue(null).required(false).addValidator(StandardValidators.URL_VALIDATOR).build();
    public static final PropertyDescriptor DB_USER = new PropertyDescriptor.Builder().name("Database User").description("Database user name").defaultValue(null).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor DB_PASSWORD = new PropertyDescriptor.Builder().name("Password").description("The password for the database user").defaultValue(null).required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor MAX_WAIT_TIME = new PropertyDescriptor.Builder().name("Max Wait Time").description("The maximum amount of time that the pool will wait (when there are no available connections)  for a connection to be returned before failing, or -1 to wait indefinitely. ").defaultValue("500 millis").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor MAX_TOTAL_CONNECTIONS = new PropertyDescriptor.Builder().name("Max Total Connections").description("The maximum number of active connections that can be allocated from this pool at the same time,  or negative for no limit.").defaultValue("8").required(true).addValidator(StandardValidators.INTEGER_VALIDATOR).sensitive(false).build();
    private static final List<PropertyDescriptor> properties;
    private volatile BasicDataSource dataSource;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        String drv = context.getProperty(DB_DRIVERNAME).getValue();
        String user = context.getProperty(DB_USER).getValue();
        String passw = context.getProperty(DB_PASSWORD).getValue();
        Long maxWaitMillis = context.getProperty(MAX_WAIT_TIME).asTimePeriod(TimeUnit.MILLISECONDS);
        Integer maxTotal = context.getProperty(MAX_TOTAL_CONNECTIONS).asInteger();
        this.dataSource = new BasicDataSource();
        this.dataSource.setDriverClassName(drv);
        String urlString = context.getProperty(DB_DRIVER_JAR_URL).getValue();
        this.dataSource.setDriverClassLoader(this.getDriverClassLoader(urlString, drv));
        String dburl = context.getProperty(DATABASE_URL).getValue();
        this.dataSource.setMaxWait(maxWaitMillis.longValue());
        this.dataSource.setMaxActive(maxTotal.intValue());
        this.dataSource.setUrl(dburl);
        this.dataSource.setUsername(user);
        this.dataSource.setPassword(passw);
    }

    protected ClassLoader getDriverClassLoader(String urlString, String drvName) throws InitializationException {
        if (urlString != null && urlString.length() > 0) {
            try {
                URL[] urls = new URL[]{new URL(urlString)};
                URLClassLoader ucl = new URLClassLoader(urls);
                Class<?> clazz = Class.forName(drvName, true, ucl);
                if (clazz == null) {
                    throw new InitializationException("Can't load Database Driver " + drvName);
                }
                Driver driver = (Driver)clazz.newInstance();
                DriverManager.registerDriver(new DriverShim(driver));
                return ucl;
            }
            catch (MalformedURLException e) {
                throw new InitializationException("Invalid Database Driver Jar Url", (Throwable)e);
            }
            catch (Exception e) {
                throw new InitializationException("Can't load Database Driver", (Throwable)e);
            }
        }
        return Thread.currentThread().getContextClassLoader();
    }

    @OnDisabled
    public void shutdown() {
        try {
            this.dataSource.close();
        }
        catch (SQLException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public Connection getConnection() throws ProcessException {
        try {
            Connection con = this.dataSource.getConnection();
            return con;
        }
        catch (SQLException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public String toString() {
        return "DBCPConnectionPool[id=" + this.getIdentifier() + "]";
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(DATABASE_URL);
        props.add(DB_DRIVERNAME);
        props.add(DB_DRIVER_JAR_URL);
        props.add(DB_USER);
        props.add(DB_PASSWORD);
        props.add(MAX_WAIT_TIME);
        props.add(MAX_TOTAL_CONNECTIONS);
        properties = Collections.unmodifiableList(props);
    }
}

