/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@Tags(value={"dbcp", "jdbc", "database", "connection", "pooling", "store"})
@CapabilityDescription(value="Provides a DBCPService that can be used to dynamically select another DBCPService. This service requires an attribute named 'database.name' to be passed in when asking for a connection, and will throw an exception if the attribute is missing. The value of 'database.name' will be used to select the DBCPService that has been registered with that name. This will allow multiple DBCPServices to be defined and registered, and then selected dynamically at runtime by tagging flow files with the appropriate 'database.name' attribute.")
@DynamicProperty(name="The ", value="JDBC property value", expressionLanguageScope=ExpressionLanguageScope.NONE, description="")
public class DBCPConnectionPoolLookup
extends AbstractControllerService
implements DBCPService {
    public static final String DATABASE_NAME_ATTRIBUTE = "database.name";
    private volatile Map<String, DBCPService> dbcpServiceMap;

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("The DBCPService to return when database.name = '" + propertyDescriptorName + "'").identifiesControllerService(DBCPService.class).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        int numDefinedServices = 0;
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (descriptor.isDynamic()) {
                ++numDefinedServices;
            }
            String referencedId = context.getProperty(descriptor).getValue();
            if (!this.getIdentifier().equals(referencedId)) continue;
            results.add(new ValidationResult.Builder().subject(descriptor.getDisplayName()).explanation("the current service cannot be registered as a DBCPService to lookup").valid(false).build());
        }
        if (numDefinedServices == 0) {
            results.add(new ValidationResult.Builder().subject(((Object)((Object)this)).getClass().getSimpleName()).explanation("at least one DBCPService must be defined via dynamic properties").valid(false).build());
        }
        return results;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        HashMap<String, DBCPService> serviceMap = new HashMap<String, DBCPService>();
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (!descriptor.isDynamic()) continue;
            DBCPService dbcpService = (DBCPService)context.getProperty(descriptor).asControllerService(DBCPService.class);
            serviceMap.put(descriptor.getName(), dbcpService);
        }
        this.dbcpServiceMap = Collections.unmodifiableMap(serviceMap);
    }

    @OnDisabled
    public void onDisabled() {
        this.dbcpServiceMap = null;
    }

    public Connection getConnection() throws ProcessException {
        throw new UnsupportedOperationException("Cannot lookup DBCPConnectionPool without attributes");
    }

    public Connection getConnection(Map<String, String> attributes) throws ProcessException {
        if (!attributes.containsKey(DATABASE_NAME_ATTRIBUTE)) {
            throw new ProcessException("Attributes must contain an attribute name 'database.name'");
        }
        String databaseName = attributes.get(DATABASE_NAME_ATTRIBUTE);
        if (StringUtils.isBlank((CharSequence)databaseName)) {
            throw new ProcessException("database.name cannot be null or blank");
        }
        DBCPService dbcpService = this.dbcpServiceMap.get(databaseName);
        if (dbcpService == null) {
            throw new ProcessException("No DBCPService was found for database.name '" + databaseName + "'");
        }
        return dbcpService.getConnection(attributes);
    }
}

