/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.enrich;

import com.sun.jndi.dns.DnsContextFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.enrich.AbstractEnrichProcessor;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"dns", "enrich", "ip"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="A powerful DNS query processor primary designed to enrich DataFlows with DNS based APIs (e.g. RBLs, ShadowServer's ASN lookup) but that can be also used to perform regular DNS lookups.")
@WritesAttributes(value={@WritesAttribute(attribute="enrich.dns.record*.group*", description="The captured fields of the DNS query response for each of the records received")})
public class QueryDNS
extends AbstractEnrichProcessor {
    public static final PropertyDescriptor DNS_QUERY_TYPE = new PropertyDescriptor.Builder().name("DNS_QUERY_TYPE").displayName("DNS Query Type").description("The DNS query type to be used by the processor (e.g. TXT, A)").required(true).defaultValue("TXT").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor DNS_SERVER = new PropertyDescriptor.Builder().name("DNS_SERVER").displayName("DNS Servers").description("A comma separated list of  DNS servers to be used. (Defaults to system wide if none is used)").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor DNS_TIMEOUT = new PropertyDescriptor.Builder().name("DNS_TIMEOUT").displayName("DNS Query Timeout").description("The amount of time to wait until considering a query as failed").required(true).defaultValue("1500 ms").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor DNS_RETRIES = new PropertyDescriptor.Builder().name("DNS_RETRIES").displayName("DNS Query Retries").description("The number of attempts before giving up and moving on").required(true).defaultValue("1").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final List<PropertyDescriptor> propertyDescriptors;
    private static final Set<Relationship> relationships;
    private DirContext ictx;
    private String contextFactory = DnsContextFactory.class.getName();
    private AtomicBoolean initialized = new AtomicBoolean(false);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile;
        if (!this.initialized.get()) {
            this.initializeResolver(context);
            this.getLogger().warn("Resolver was initialized at onTrigger instead of onScheduled");
        }
        if ((flowFile = session.get()) == null) {
            return;
        }
        String queryType = context.getProperty(DNS_QUERY_TYPE).getValue();
        String queryInput = context.getProperty(QUERY_INPUT).evaluateAttributeExpressions(flowFile).getValue();
        String queryParser = context.getProperty(QUERY_PARSER).getValue();
        String queryRegex = context.getProperty(QUERY_PARSER_INPUT).getValue();
        boolean found = false;
        try {
            Attributes results = this.doLookup(queryInput, queryType);
            if (results.size() < 1) {
                found = false;
            } else {
                int recordNumber = 0;
                NamingEnumeration<?> dnsEntryIterator = results.get(queryType).getAll();
                while (dnsEntryIterator.hasMoreElements()) {
                    String dnsRecord = dnsEntryIterator.next().toString();
                    if (dnsRecord != "NXDOMAIN") {
                        Map<String, String> parsedResults = this.parseResponse(String.valueOf(recordNumber), dnsRecord, queryParser, queryRegex, "dns");
                        flowFile = session.putAllAttributes(flowFile, parsedResults);
                        found = true;
                    } else {
                        found = false;
                    }
                    ++recordNumber;
                }
            }
        }
        catch (NamingException e) {
            context.yield();
            throw new ProcessException("Unexpected NamingException while processing records. Please review your configuration.", (Throwable)e);
        }
        if (found) {
            session.transfer(flowFile, REL_FOUND);
        } else {
            session.transfer(flowFile, REL_NOT_FOUND);
        }
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        try {
            this.initializeResolver(context);
        }
        catch (Exception e) {
            context.yield();
            throw new ProcessException("Failed to initialize the JNDI DNS resolver server", (Throwable)e);
        }
    }

    protected void initializeResolver(ProcessContext context) {
        String dnsTimeout = context.getProperty(DNS_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).toString();
        String dnsServer = context.getProperty(DNS_SERVER).getValue();
        String dnsRetries = context.getProperty(DNS_RETRIES).getValue();
        String finalServer = "";
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.contextFactory);
        env.put("com.sun.jndi.dns.timeout.initial", dnsTimeout);
        env.put("com.sun.jndi.dns.timeout.retries", dnsRetries);
        if (StringUtils.isNotEmpty((CharSequence)dnsServer)) {
            for (String server : dnsServer.split(",")) {
                finalServer = finalServer + "dns://" + server + "/. ";
            }
            env.put("java.naming.provider.url", finalServer);
        }
        try {
            this.initializeContext(env);
            this.initialized.set(true);
        }
        catch (NamingException e) {
            this.getLogger().error("Could not initialize JNDI context", (Throwable)e);
        }
    }

    protected Attributes doLookup(String queryInput, String queryType) throws NamingException {
        try {
            Attributes attrs = this.ictx.getAttributes(queryInput, new String[]{queryType});
            return attrs;
        }
        catch (NameNotFoundException e) {
            this.getLogger().debug("Resolution for domain {} failed due to {}", new Object[]{queryInput, e});
            BasicAttributes attrs = new BasicAttributes(queryType, "NXDOMAIN", true);
            return attrs;
        }
    }

    protected void initializeContext(Hashtable<String, String> env) throws NamingException {
        this.ictx = new InitialDirContext(env);
        this.initialized = new AtomicBoolean(false);
        this.initialized.set(true);
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(QUERY_INPUT);
        props.add(QUERY_PARSER);
        props.add(QUERY_PARSER_INPUT);
        props.add(DNS_RETRIES);
        props.add(DNS_TIMEOUT);
        props.add(DNS_SERVER);
        props.add(DNS_QUERY_TYPE);
        propertyDescriptors = Collections.unmodifiableList(props);
        HashSet<Relationship> rels = new HashSet<Relationship>();
        rels.add(REL_FOUND);
        rels.add(REL_NOT_FOUND);
        relationships = Collections.unmodifiableSet(rels);
    }
}

