/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.maxmind;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.maxmind.db.Metadata;
import com.maxmind.db.Reader;
import com.maxmind.geoip2.GeoIp2Provider;
import com.maxmind.geoip2.model.AnonymousIpResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.ConnectionTypeResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.DomainResponse;
import com.maxmind.geoip2.model.IspResponse;
import com.maxmind.geoip2.record.Traits;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;

public class DatabaseReader
implements GeoIp2Provider,
Closeable {
    private final Reader reader;
    private final ObjectMapper om;
    private List<String> locales;

    private DatabaseReader(Builder builder) throws IOException {
        if (builder.stream != null) {
            this.reader = new Reader(builder.stream);
        } else if (builder.database != null) {
            this.reader = new Reader(builder.database, builder.mode);
        } else {
            throw new IllegalArgumentException("Unsupported Builder configuration: expected either File or URL");
        }
        this.om = new ObjectMapper();
        this.om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.om.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        InjectableValues.Std inject = new InjectableValues.Std().addValue("locales", builder.locales);
        this.om.setInjectableValues((InjectableValues)inject);
        this.locales = builder.locales;
    }

    private <T> T get(InetAddress ipAddress, Class<T> cls, boolean hasTraits, String type) throws IOException {
        String databaseType = this.getMetadata().getDatabaseType();
        if (!databaseType.contains(type)) {
            String caller = Thread.currentThread().getStackTrace()[2].getMethodName();
            throw new UnsupportedOperationException("Invalid attempt to open a " + databaseType + " database using the " + caller + " method");
        }
        ObjectNode node = (ObjectNode)this.reader.get(ipAddress);
        if (node == null) {
            return null;
        }
        JsonInjector inject = new JsonInjector(ipAddress.getHostAddress());
        return (T)this.om.reader((InjectableValues)inject).treeToValue((TreeNode)node, cls);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public CountryResponse country(InetAddress ipAddress) throws IOException {
        return this.get(ipAddress, CountryResponse.class, true, "Country");
    }

    public CityResponse city(InetAddress ipAddress) throws IOException {
        return this.get(ipAddress, CityResponse.class, true, "City");
    }

    public AnonymousIpResponse anonymousIp(InetAddress ipAddress) throws IOException {
        return this.get(ipAddress, AnonymousIpResponse.class, false, "GeoIP2-Anonymous-IP");
    }

    public ConnectionTypeResponse connectionType(InetAddress ipAddress) throws IOException {
        return this.get(ipAddress, ConnectionTypeResponse.class, false, "GeoIP2-Connection-Type");
    }

    public DomainResponse domain(InetAddress ipAddress) throws IOException {
        return this.get(ipAddress, DomainResponse.class, false, "GeoIP2-Domain");
    }

    public IspResponse isp(InetAddress ipAddress) throws IOException {
        return this.get(ipAddress, IspResponse.class, false, "GeoIP2-ISP");
    }

    public Metadata getMetadata() {
        return this.reader.getMetadata();
    }

    private class JsonInjector
    extends InjectableValues {
        private final String ip;

        JsonInjector(String ip) {
            this.ip = ip;
        }

        public Object findInjectableValue(Object valueId, DeserializationContext ctxt, BeanProperty forProperty, Object beanInstance) throws JsonMappingException {
            if ("ip_address".equals(valueId)) {
                return this.ip;
            }
            if ("traits".equals(valueId)) {
                return new Traits(this.ip);
            }
            if ("locales".equals(valueId)) {
                return DatabaseReader.this.locales;
            }
            return null;
        }
    }

    public static final class Builder {
        final File database;
        final InputStream stream;
        List<String> locales = Arrays.asList("en");
        Reader.FileMode mode = Reader.FileMode.MEMORY_MAPPED;

        public Builder(InputStream stream) {
            this.stream = stream;
            this.database = null;
        }

        public Builder(File database) {
            this.database = database;
            this.stream = null;
        }

        public Builder locales(List<String> val) {
            this.locales = val;
            return this;
        }

        public Builder fileMode(Reader.FileMode val) {
            if (this.stream != null && !Reader.FileMode.MEMORY.equals((Object)val)) {
                throw new IllegalArgumentException("Only FileMode.MEMORY is supported when using an InputStream.");
            }
            this.mode = val;
            return this;
        }

        public DatabaseReader build() throws IOException {
            return new DatabaseReader(this);
        }
    }
}

