/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx;

import com.google.common.net.MediaType;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;

public class ResultProcessor {
    private final Relationship successRelationship;
    private final Relationship failureRelationship;
    public static final String UNABLE_TO_PROCESS_DUE_TO = "Unable to process {} due to {}";

    public ResultProcessor(Relationship successRelationship, Relationship failureRelationship) {
        this.successRelationship = successRelationship;
        this.failureRelationship = failureRelationship;
    }

    public void process(ProcessSession session, ComponentLog logger, FlowFile updated, Exception exception, String name) {
        updated = session.putAttribute(updated, CoreAttributes.FILENAME.key(), name);
        updated = session.putAttribute(updated, CoreAttributes.MIME_TYPE.key(), MediaType.APPLICATION_XML_UTF_8.toString());
        if (exception == null) {
            session.transfer(updated, this.successRelationship);
        } else {
            logger.error(UNABLE_TO_PROCESS_DUE_TO, new Object[]{name, exception}, (Throwable)exception);
            session.transfer(updated, this.failureRelationship);
        }
    }
}

