/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager.impl;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.manager.HttpResponseMapper;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.node.Node;
import org.apache.nifi.logging.NiFiLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseMapperImpl
implements HttpResponseMapper {
    private static final Logger logger = new NiFiLog(LoggerFactory.getLogger(HttpResponseMapperImpl.class));

    @Override
    public Map<NodeResponse, Node.Status> map(URI requestURI, Set<NodeResponse> nodeResponses) {
        HashMap<NodeResponse, Node.Status> result = new HashMap<NodeResponse, Node.Status>();
        boolean found2xx = false;
        for (NodeResponse nodeResponse : nodeResponses) {
            if (!nodeResponse.is2xx()) continue;
            found2xx = true;
            break;
        }
        for (NodeResponse nodeResponse : nodeResponses) {
            Node.Status status = found2xx ? (nodeResponse.is2xx() ? Node.Status.CONNECTED : Node.Status.DISCONNECTED) : (nodeResponse.is5xx() ? Node.Status.DISCONNECTED : Node.Status.CONNECTED);
            result.put(nodeResponse, status);
        }
        return result;
    }
}

