/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.spring;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.cluster.protocol.impl.ClusterServiceDiscovery;
import org.apache.nifi.cluster.protocol.impl.ClusterServiceLocator;
import org.apache.nifi.io.socket.multicast.DiscoverableService;
import org.apache.nifi.io.socket.multicast.DiscoverableServiceImpl;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ClusterManagerProtocolServiceLocatorFactoryBean
implements FactoryBean,
ApplicationContextAware,
DisposableBean {
    private ApplicationContext applicationContext;
    private ClusterServiceLocator locator;
    private NiFiProperties properties;

    public Object getObject() throws Exception {
        if (this.properties.isClusterManager()) {
            return null;
        }
        if (this.locator == null) {
            if (this.properties.getClusterProtocolUseMulticast()) {
                ClusterServiceDiscovery serviceDiscovery = (ClusterServiceDiscovery)this.applicationContext.getBean("clusterManagerProtocolServiceDiscovery", ClusterServiceDiscovery.class);
                ClusterServiceLocator.AttemptsConfig config = new ClusterServiceLocator.AttemptsConfig();
                config.setNumAttempts(this.properties.getClusterProtocolMulticastServiceLocatorAttempts());
                int delay = (int)FormatUtils.getTimeDuration((String)this.properties.getClusterProtocolMulticastServiceLocatorAttemptsDelay(), (TimeUnit)TimeUnit.SECONDS);
                config.setTimeBetweenAttempts(delay);
                config.setTimeBetweenAttempsUnit(TimeUnit.SECONDS);
                this.locator = new ClusterServiceLocator(serviceDiscovery);
                this.locator.setAttemptsConfig(config);
            } else {
                String serviceName = (String)this.applicationContext.getBean("clusterManagerProtocolServiceName", String.class);
                InetSocketAddress serviceAddress = this.properties.getClusterNodeUnicastManagerProtocolAddress();
                DiscoverableServiceImpl service = new DiscoverableServiceImpl(serviceName, serviceAddress);
                this.locator = new ClusterServiceLocator((DiscoverableService)service);
            }
            this.locator.start();
        }
        return this.locator;
    }

    public Class getObjectType() {
        return ClusterServiceLocator.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        if (this.locator != null && this.locator.isRunning()) {
            this.locator.stop();
        }
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }
}

