/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.event.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.nifi.cluster.event.Event;
import org.apache.nifi.cluster.event.EventManager;

public class EventManagerImpl
implements EventManager {
    private final Map<String, Queue<Event>> eventsMap = new HashMap<String, Queue<Event>>();
    private final int eventHistorySize;

    public EventManagerImpl(int eventHistorySize) {
        if (eventHistorySize <= 0) {
            throw new IllegalArgumentException("Event history size must be positive: " + eventHistorySize);
        }
        this.eventHistorySize = eventHistorySize;
    }

    @Override
    public void addEvent(Event event) {
        if (event == null) {
            throw new IllegalArgumentException("Event may not be null.");
        }
        Queue<Event> events = this.eventsMap.get(event.getSource());
        if (events == null) {
            events = new PriorityQueue<Event>(this.eventHistorySize, this.createEventComparator());
            this.eventsMap.put(event.getSource(), events);
        }
        events.add(event);
        if (events.size() > this.eventHistorySize) {
            this.removeOldestEvent(events);
        }
    }

    @Override
    public List<Event> getEvents(String eventSource) {
        Queue<Event> events = this.eventsMap.get(eventSource);
        if (events == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(new ArrayList<Event>(events));
    }

    @Override
    public int getEventHistorySize() {
        return this.eventHistorySize;
    }

    @Override
    public Event getMostRecentEvent(String eventSource) {
        Queue<Event> events = this.eventsMap.get(eventSource);
        if (events == null) {
            return null;
        }
        return events.peek();
    }

    @Override
    public void clearEventHistory(String eventSource) {
        this.eventsMap.remove(eventSource);
    }

    private Comparator createEventComparator() {
        return new Comparator<Event>(){

            @Override
            public int compare(Event o1, Event o2) {
                return (int)(o2.getTimestamp() - o1.getTimestamp());
            }
        };
    }

    private void removeOldestEvent(Collection<Event> events) {
        if (events.isEmpty()) {
            return;
        }
        Event oldestEvent = null;
        for (Event event : events) {
            if (oldestEvent != null && oldestEvent.getTimestamp() <= event.getTimestamp()) continue;
            oldestEvent = event;
        }
        events.remove(oldestEvent);
    }
}

