/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.credentials.service;

import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.gcp.credentials.service.GCPCredentialsService;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.gcp.ProxyAwareTransportFactory;
import org.apache.nifi.processors.gcp.credentials.factory.CredentialPropertyDescriptors;
import org.apache.nifi.processors.gcp.credentials.factory.CredentialsFactory;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.reporting.InitializationException;

@CapabilityDescription(value="Defines credentials for Google Cloud Platform processors. Uses Application Default credentials without configuration. Application Default credentials support environmental variable (GOOGLE_APPLICATION_CREDENTIALS) pointing to a credential file, the config generated by `gcloud auth application-default login`, AppEngine/Compute Engine service accounts, etc.")
@Tags(value={"gcp", "credentials", "provider"})
public class GCPCredentialsControllerService
extends AbstractControllerService
implements GCPCredentialsService {
    private static final List<PropertyDescriptor> properties;
    private volatile GoogleCredentials googleCredentials;
    protected final CredentialsFactory credentialsProviderFactory = new CredentialsFactory();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public GoogleCredentials getGoogleCredentials() throws ProcessException {
        return this.googleCredentials;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        Collection<ValidationResult> results = this.credentialsProviderFactory.validate(validationContext);
        ProxyConfiguration.validateProxySpec((ValidationContext)validationContext, results, (ProxySpec[])ProxyAwareTransportFactory.PROXY_SPECS);
        return results;
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        try {
            ProxyConfiguration proxyConfiguration = ProxyConfiguration.getConfiguration((PropertyContext)context);
            ProxyAwareTransportFactory transportFactory = new ProxyAwareTransportFactory(proxyConfiguration);
            this.googleCredentials = this.credentialsProviderFactory.getGoogleCredentials(context.getProperties(), transportFactory);
        }
        catch (IOException e) {
            throw new InitializationException((Throwable)e);
        }
    }

    public String toString() {
        return "GCPCredentialsControllerService[id=" + this.getIdentifier() + "]";
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(CredentialPropertyDescriptors.USE_APPLICATION_DEFAULT_CREDENTIALS);
        props.add(CredentialPropertyDescriptors.USE_COMPUTE_ENGINE_CREDENTIALS);
        props.add(CredentialPropertyDescriptors.SERVICE_ACCOUNT_JSON_FILE);
        props.add(CredentialPropertyDescriptors.SERVICE_ACCOUNT_JSON);
        props.add(ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)false, (ProxySpec[])ProxyAwareTransportFactory.PROXY_SPECS));
        properties = Collections.unmodifiableList(props);
    }
}

