/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.processors;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.nifi.jms.processors.JMSWorker;
import org.apache.nifi.jms.processors.MessageBodyToBytesConverter;
import org.apache.nifi.logging.ProcessorLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;

final class JMSConsumer
extends JMSWorker {
    private static final Logger logger = LoggerFactory.getLogger(JMSConsumer.class);

    JMSConsumer(JmsTemplate jmsTemplate, ProcessorLog processLog) {
        super(jmsTemplate, processLog);
        if (logger.isInfoEnabled()) {
            logger.info("Created Message Consumer for '" + jmsTemplate.toString() + "'.");
        }
    }

    public JMSResponse consume() {
        Message message = this.jmsTemplate.receive();
        if (message != null) {
            byte[] messageBody = null;
            try {
                if (message instanceof TextMessage) {
                    messageBody = MessageBodyToBytesConverter.toBytes((TextMessage)message);
                } else if (message instanceof BytesMessage) {
                    messageBody = MessageBodyToBytesConverter.toBytes((BytesMessage)message);
                } else {
                    throw new UnsupportedOperationException("Message type other then TextMessage and BytesMessage are not supported at the moment");
                }
                Map<String, Object> messageHeaders = this.extractMessageHeaders(message);
                Map<String, String> messageProperties = this.extractMessageProperties(message);
                return new JMSResponse(messageBody, messageHeaders, messageProperties);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    private Map<String, String> extractMessageProperties(Message message) {
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            Enumeration propertyNames = message.getPropertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = (String)propertyNames.nextElement();
                properties.put(propertyName, String.valueOf(message.getObjectProperty(propertyName)));
            }
        }
        catch (JMSException e) {
            logger.warn("Failed to extract message properties", (Throwable)e);
            this.processLog.warn("Failed to extract message properties", (Throwable)e);
        }
        return properties;
    }

    private Map<String, Object> extractMessageHeaders(Message message) {
        HashMap<String, Object> messageHeaders = new HashMap<String, Object>();
        try {
            String destinationName;
            messageHeaders.put("jms_deliveryMode", String.valueOf(message.getJMSDeliveryMode()));
            messageHeaders.put("jms_expiration", String.valueOf(message.getJMSExpiration()));
            messageHeaders.put("jms_priority", String.valueOf(message.getJMSPriority()));
            messageHeaders.put("jms_redelivered", String.valueOf(message.getJMSRedelivered()));
            messageHeaders.put("jms_timestamp", String.valueOf(message.getJMSTimestamp()));
            messageHeaders.put("jms_correlationId", message.getJMSCorrelationID());
            messageHeaders.put("jms_messageId", message.getJMSMessageID());
            messageHeaders.put("jms_type", message.getJMSType());
            String replyToDestinationName = this.retrieveDestinationName(message.getJMSReplyTo(), "jms_replyTo");
            if (replyToDestinationName != null) {
                messageHeaders.put("jms_replyTo", replyToDestinationName);
            }
            if ((destinationName = this.retrieveDestinationName(message.getJMSDestination(), "jms_destination")) != null) {
                messageHeaders.put("jms_destination", destinationName);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to extract JMS Headers", e);
        }
        return messageHeaders;
    }

    private String retrieveDestinationName(Destination destination, String headerName) {
        String destinationName = null;
        if (destination != null) {
            try {
                destinationName = destination instanceof Queue ? ((Queue)destination).getQueueName() : ((Topic)destination).getTopicName();
            }
            catch (JMSException e) {
                logger.warn("Failed to retrieve Destination name for '" + headerName + "' header", (Throwable)e);
                this.processLog.warn("Failed to retrieve Destination name for '" + headerName + "' header", (Throwable)e);
            }
        }
        return destinationName;
    }

    static class JMSResponse {
        private final byte[] messageBody;
        private final Map<String, Object> messageHeaders;
        private final Map<String, String> messageProperties;

        JMSResponse(byte[] messageBody, Map<String, Object> messageHeaders, Map<String, String> messageProperties) {
            this.messageBody = messageBody;
            this.messageHeaders = Collections.unmodifiableMap(messageHeaders);
            this.messageProperties = Collections.unmodifiableMap(messageProperties);
        }

        public byte[] getMessageBody() {
            return this.messageBody;
        }

        public Map<String, Object> getMessageHeaders() {
            return this.messageHeaders;
        }

        public Map<String, String> getMessageProperties() {
            return this.messageProperties;
        }
    }
}

