/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.processors;

import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.nifi.jms.processors.JMSWorker;
import org.apache.nifi.logging.ProcessorLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.SessionCallback;

final class JMSPublisher
extends JMSWorker {
    private static final Logger logger = LoggerFactory.getLogger(JMSPublisher.class);

    JMSPublisher(JmsTemplate jmsTemplate, ProcessorLog processLog) {
        super(jmsTemplate, processLog);
        if (logger.isInfoEnabled()) {
            logger.info("Created Message Publisher for '" + jmsTemplate.toString() + "'.");
        }
    }

    void publish(byte[] messageBytes) {
        this.publish(messageBytes, null);
    }

    void publish(final byte[] messageBytes, final Map<String, String> flowFileAttributes) {
        this.jmsTemplate.send(new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                BytesMessage message = session.createBytesMessage();
                message.writeBytes(messageBytes);
                if (flowFileAttributes != null && !flowFileAttributes.isEmpty()) {
                    for (Map.Entry entry : flowFileAttributes.entrySet()) {
                        Destination destination;
                        if (!((String)entry.getKey()).startsWith("jms_") && !((String)entry.getKey()).contains("-")) {
                            message.setStringProperty((String)entry.getKey(), (String)entry.getValue());
                            continue;
                        }
                        if (((String)entry.getKey()).equals("jms_deliveryMode")) {
                            message.setJMSDeliveryMode(Integer.parseInt((String)entry.getValue()));
                            continue;
                        }
                        if (((String)entry.getKey()).equals("jms_expiration")) {
                            message.setJMSExpiration((long)Integer.parseInt((String)entry.getValue()));
                            continue;
                        }
                        if (((String)entry.getKey()).equals("jms_priority")) {
                            message.setJMSPriority(Integer.parseInt((String)entry.getValue()));
                            continue;
                        }
                        if (((String)entry.getKey()).equals("jms_redelivered")) {
                            message.setJMSRedelivered(Boolean.parseBoolean((String)entry.getValue()));
                            continue;
                        }
                        if (((String)entry.getKey()).equals("jms_timestamp")) {
                            message.setJMSTimestamp(Long.parseLong((String)entry.getValue()));
                            continue;
                        }
                        if (((String)entry.getKey()).equals("jms_correlationId")) {
                            message.setJMSCorrelationID((String)entry.getValue());
                            continue;
                        }
                        if (((String)entry.getKey()).equals("jms_type")) {
                            message.setJMSType((String)entry.getValue());
                            continue;
                        }
                        if (((String)entry.getKey()).equals("jms_replyTo")) {
                            destination = JMSPublisher.this.buildDestination((String)entry.getValue());
                            if (destination != null) {
                                message.setJMSReplyTo(destination);
                                continue;
                            }
                            JMSPublisher.this.logUnbuildableDestination((String)entry.getKey(), "jms_replyTo");
                            continue;
                        }
                        if (!((String)entry.getKey()).equals("jms_destination")) continue;
                        destination = JMSPublisher.this.buildDestination((String)entry.getValue());
                        if (destination != null) {
                            message.setJMSDestination(destination);
                            continue;
                        }
                        JMSPublisher.this.logUnbuildableDestination((String)entry.getKey(), "jms_destination");
                    }
                }
                return message;
            }
        });
    }

    private void logUnbuildableDestination(String destinationName, String headerName) {
        logger.warn("Failed to determine destination type from destination name '" + destinationName + "'. The '" + headerName + "' will not be set.");
        this.processLog.warn("Failed to determine destination type from destination name '" + destinationName + "'. The '" + headerName + "' will not be set.");
    }

    private Destination buildDestination(final String destinationName) {
        Destination destination = destinationName.toLowerCase().contains("topic") ? (Destination)this.jmsTemplate.execute((SessionCallback)new SessionCallback<Topic>(){

            public Topic doInJms(Session session) throws JMSException {
                return session.createTopic(destinationName);
            }
        }) : (destinationName.toLowerCase().contains("queue") ? (Destination)this.jmsTemplate.execute((SessionCallback)new SessionCallback<Queue>(){

            public Queue doInJms(Session session) throws JMSException {
                return session.createQueue(destinationName);
            }
        }) : null);
        return destination;
    }
}

