/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.processors;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.jms.cf.JMSConnectionFactoryProvider;
import org.apache.nifi.jms.processors.AbstractJMSProcessor;
import org.apache.nifi.jms.processors.JMSConsumer;
import org.apache.nifi.jms.processors.PublishJMS;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.springframework.jms.core.JmsTemplate;

@Tags(value={"jms", "get", "message", "receive", "consume"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@CapabilityDescription(value="Consumes JMS Message of type BytesMessage or TextMessage transforming its content to a FlowFile and transitioning it to 'success' relationship.")
@SeeAlso(value={PublishJMS.class, JMSConnectionFactoryProvider.class})
public class ConsumeJMS
extends AbstractJMSProcessor<JMSConsumer> {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that are received from the JMS Destination are routed to this relationship").build();
    private static final Set<Relationship> relationships;

    @Override
    protected void rendezvousWithJms(ProcessContext context, ProcessSession processSession) throws ProcessException {
        final JMSConsumer.JMSResponse response = ((JMSConsumer)this.targetResource).consume();
        if (response != null) {
            FlowFile flowFile = processSession.create();
            flowFile = processSession.write(flowFile, new OutputStreamCallback(){

                public void process(OutputStream out) throws IOException {
                    out.write(response.getMessageBody());
                }
            });
            Map<String, Object> jmsHeaders = response.getMessageHeaders();
            flowFile = this.updateFlowFileAttributesWithJmsHeaders(jmsHeaders, flowFile, processSession);
            processSession.getProvenanceReporter().receive(flowFile, context.getProperty(DESTINATION).evaluateAttributeExpressions().getValue());
            processSession.transfer(flowFile, REL_SUCCESS);
        } else {
            context.yield();
        }
    }

    @Override
    protected JMSConsumer finishBuildingTargetResource(JmsTemplate jmsTemplate) {
        return new JMSConsumer(jmsTemplate, this.getLogger());
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    private FlowFile updateFlowFileAttributesWithJmsHeaders(Map<String, Object> jmsHeaders, FlowFile flowFile, ProcessSession processSession) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Map.Entry<String, Object> headersEntry : jmsHeaders.entrySet()) {
            attributes.put(headersEntry.getKey(), String.valueOf(headersEntry.getValue()));
        }
        flowFile = processSession.putAllAttributes(flowFile, attributes);
        return flowFile;
    }

    static {
        HashSet<Relationship> _relationships = new HashSet<Relationship>();
        _relationships.add(REL_SUCCESS);
        relationships = Collections.unmodifiableSet(_relationships);
    }
}

