/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.processors;

import java.io.IOException;
import java.io.InputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.commons.io.IOUtils;

abstract class MessageBodyToBytesConverter {
    MessageBodyToBytesConverter() {
    }

    public static byte[] toBytes(TextMessage message) {
        try {
            return message.getText().getBytes();
        }
        catch (JMSException e) {
            throw new MessageConversionException("Failed to convert BytesMessage to byte[]", e);
        }
    }

    public static byte[] toBytes(BytesMessage message) {
        try {
            BytesMessageInputStream is = new BytesMessageInputStream(message);
            return IOUtils.toByteArray((InputStream)is);
        }
        catch (Exception e) {
            throw new MessageConversionException("Failed to convert BytesMessage to byte[]", e);
        }
    }

    static class MessageConversionException
    extends RuntimeException {
        private static final long serialVersionUID = -1464448549601643887L;

        public MessageConversionException(String msg) {
            super(msg);
        }

        public MessageConversionException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    private static class BytesMessageInputStream
    extends InputStream {
        private BytesMessage message;

        public BytesMessageInputStream(BytesMessage message) {
            this.message = message;
        }

        @Override
        public int read() throws IOException {
            try {
                return this.message.readByte();
            }
            catch (JMSException e) {
                throw new IOException(e.toString());
            }
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            try {
                if (offset == 0) {
                    return this.message.readBytes(buffer, length);
                }
                return super.read(buffer, offset, length);
            }
            catch (JMSException e) {
                throw new IOException(e.toString());
            }
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            try {
                return this.message.readBytes(buffer);
            }
            catch (JMSException e) {
                throw new IOException(e.toString());
            }
        }
    }
}

