/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.cf;

import java.util.List;
import javax.jms.ConnectionFactory;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.jms.cf.JMSConnectionFactoryHandler;
import org.apache.nifi.jms.cf.JMSConnectionFactoryProperties;
import org.apache.nifi.jms.cf.JMSConnectionFactoryProviderDefinition;

@Tags(value={"jms", "messaging", "integration", "queue", "topic", "publish", "subscribe"})
@CapabilityDescription(value="Provides a generic service to create vendor specific javax.jms.ConnectionFactory implementations. The Connection Factory can be served once this service is configured successfully.")
@DynamicProperty(name="The name of a Connection Factory configuration property.", value="The value of a given Connection Factory configuration property.", description="The properties that are set following Java Beans convention where a property name is derived from the 'set*' method of the vendor specific ConnectionFactory's implementation. For example, 'com.ibm.mq.jms.MQConnectionFactory.setChannel(String)' would imply 'channel' property and 'com.ibm.mq.jms.MQConnectionFactory.setTransportType(int)' would imply 'transportType' property.", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY)
@SeeAlso(classNames={"org.apache.nifi.jms.processors.ConsumeJMS", "org.apache.nifi.jms.processors.PublishJMS"})
public class JMSConnectionFactoryProvider
extends AbstractControllerService
implements JMSConnectionFactoryProviderDefinition {
    protected volatile JMSConnectionFactoryHandler delegate;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return JMSConnectionFactoryProperties.getPropertyDescriptors();
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return JMSConnectionFactoryProperties.getDynamicPropertyDescriptor(propertyDescriptorName);
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.delegate = new JMSConnectionFactoryHandler(context, this.getLogger());
    }

    @OnDisabled
    public void onDisabled() {
        this.delegate = null;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.delegate.getConnectionFactory();
    }

    public void resetConnectionFactory(ConnectionFactory cachedFactory) {
        this.delegate.resetConnectionFactory(cachedFactory);
    }
}

