/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.cf;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.net.ssl.SSLContext;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.jms.cf.CachedJMSConnectionFactoryHandler;
import org.apache.nifi.jms.cf.JMSConnectionFactoryProperties;
import org.apache.nifi.jms.cf.Utils;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.ssl.SSLContextService;

public class JMSConnectionFactoryHandler
extends CachedJMSConnectionFactoryHandler {
    private final PropertyContext context;
    private final Set<PropertyDescriptor> propertyDescriptors;
    private final ComponentLog logger;

    public JMSConnectionFactoryHandler(ConfigurationContext context, ComponentLog logger) {
        super(logger);
        this.context = context;
        this.propertyDescriptors = context.getProperties().keySet();
        this.logger = logger;
    }

    public JMSConnectionFactoryHandler(ProcessContext context, ComponentLog logger) {
        super(logger);
        this.context = context;
        this.propertyDescriptors = context.getProperties().keySet();
        this.logger = logger;
    }

    public ConnectionFactory createConnectionFactory() {
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Configuring " + ((Object)((Object)this)).getClass().getSimpleName() + " for '" + this.context.getProperty(JMSConnectionFactoryProperties.JMS_CONNECTION_FACTORY_IMPL).evaluateAttributeExpressions().getValue() + "' to be connected to '" + this.context.getProperty(JMSConnectionFactoryProperties.JMS_BROKER_URI).evaluateAttributeExpressions().getValue() + "'");
            }
            ConnectionFactory connectionFactory = this.createConnectionFactoryInstance();
            this.setConnectionFactoryProperties(connectionFactory);
            return connectionFactory;
        }
        catch (Exception e) {
            this.logger.error("Failed to configure " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private ConnectionFactory createConnectionFactoryInstance() {
        String connectionFactoryImplName = this.context.getProperty(JMSConnectionFactoryProperties.JMS_CONNECTION_FACTORY_IMPL).evaluateAttributeExpressions().getValue();
        return (ConnectionFactory)Utils.newDefaultInstance(connectionFactoryImplName);
    }

    void setConnectionFactoryProperties(ConnectionFactory connectionFactory) {
        SSLContextService sslContextService;
        String connectionFactoryValue = this.context.getProperty(JMSConnectionFactoryProperties.JMS_CONNECTION_FACTORY_IMPL).evaluateAttributeExpressions().getValue();
        if (this.context.getProperty(JMSConnectionFactoryProperties.JMS_BROKER_URI).isSet()) {
            String brokerValue = this.context.getProperty(JMSConnectionFactoryProperties.JMS_BROKER_URI).evaluateAttributeExpressions().getValue();
            if (connectionFactoryValue.startsWith("org.apache.activemq")) {
                this.setProperty(connectionFactory, "brokerURL", brokerValue);
            } else if (connectionFactoryValue.startsWith("com.tibco.tibjms")) {
                this.setProperty(connectionFactory, "serverUrl", brokerValue);
            } else if (connectionFactoryValue.startsWith("org.apache.qpid.jms")) {
                this.setProperty(connectionFactory, "remoteURI", brokerValue);
            } else {
                String[] brokerList = brokerValue.split(",");
                if (connectionFactoryValue.startsWith("com.ibm.mq.jms")) {
                    ArrayList<String> ibmConList = new ArrayList<String>();
                    for (String broker : brokerList) {
                        String[] hostPort = broker.split(":");
                        if (hostPort.length == 2) {
                            ibmConList.add(hostPort[0] + "(" + hostPort[1] + ")");
                            continue;
                        }
                        ibmConList.add(broker);
                    }
                    this.setProperty(connectionFactory, "connectionNameList", String.join((CharSequence)",", ibmConList));
                } else {
                    String[] hostPort = brokerList[0].split(":");
                    if (hostPort.length == 2) {
                        this.setProperty(connectionFactory, "hostName", hostPort[0]);
                        this.setProperty(connectionFactory, "port", hostPort[1]);
                    }
                }
            }
        }
        if ((sslContextService = (SSLContextService)this.context.getProperty(JMSConnectionFactoryProperties.JMS_SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class)) != null) {
            SSLContext sslContext = sslContextService.createContext();
            if (connectionFactoryValue.startsWith("org.apache.activemq")) {
                if (sslContextService.isTrustStoreConfigured()) {
                    this.setProperty(connectionFactory, "trustStore", sslContextService.getTrustStoreFile());
                    this.setProperty(connectionFactory, "trustStorePassword", sslContextService.getTrustStorePassword());
                    this.setProperty(connectionFactory, "trustStoreType", sslContextService.getTrustStoreType());
                }
                if (sslContextService.isKeyStoreConfigured()) {
                    this.setProperty(connectionFactory, "keyStore", sslContextService.getKeyStoreFile());
                    this.setProperty(connectionFactory, "keyStorePassword", sslContextService.getKeyStorePassword());
                    this.setProperty(connectionFactory, "keyStoreKeyPassword", sslContextService.getKeyPassword());
                    this.setProperty(connectionFactory, "keyStoreType", sslContextService.getKeyStoreType());
                }
            } else if (connectionFactoryValue.startsWith("org.apache.qpid.jms")) {
                this.setProperty(connectionFactory, "sslContext", sslContext);
            } else {
                this.setProperty(connectionFactory, "sSLSocketFactory", sslContext.getSocketFactory());
            }
        }
        this.propertyDescriptors.stream().filter(PropertyDescriptor::isDynamic).forEach(descriptor -> {
            String propertyName = descriptor.getName();
            String propertyValue = this.context.getProperty(descriptor).evaluateAttributeExpressions().getValue();
            this.setProperty(connectionFactory, propertyName, propertyValue);
        });
    }

    void setProperty(ConnectionFactory connectionFactory, String propertyName, Object propertyValue) {
        String methodName = this.toMethodName(propertyName);
        Method[] methods = Utils.findMethods(methodName, connectionFactory.getClass());
        if (methods != null && methods.length > 0) {
            try {
                for (Method method : methods) {
                    Class<?> returnType = method.getParameterTypes()[0];
                    if (String.class.isAssignableFrom(returnType)) {
                        method.invoke((Object)connectionFactory, propertyValue);
                        return;
                    }
                    if (Integer.TYPE.isAssignableFrom(returnType)) {
                        method.invoke((Object)connectionFactory, Integer.parseInt((String)propertyValue));
                        return;
                    }
                    if (Long.TYPE.isAssignableFrom(returnType)) {
                        method.invoke((Object)connectionFactory, Long.parseLong((String)propertyValue));
                        return;
                    }
                    if (!Boolean.TYPE.isAssignableFrom(returnType)) continue;
                    method.invoke((Object)connectionFactory, Boolean.parseBoolean((String)propertyValue));
                    return;
                }
                methods[0].invoke((Object)connectionFactory, propertyValue);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to set property " + propertyName, e);
            }
        } else if (propertyName.equals("hostName")) {
            this.setProperty(connectionFactory, "host", propertyValue);
        }
    }

    private String toMethodName(String propertyName) {
        char[] c = propertyName.toCharArray();
        c[0] = Character.toUpperCase(c[0]);
        return "set" + new String(c);
    }
}

