/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.processors;

import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.nifi.jms.processors.JMSWorker;
import org.apache.nifi.logging.ComponentLog;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.SessionCallback;

final class JMSPublisher
extends JMSWorker {
    JMSPublisher(CachingConnectionFactory connectionFactory, JmsTemplate jmsTemplate, ComponentLog processLog) {
        super(connectionFactory, jmsTemplate, processLog);
        processLog.debug("Created Message Publisher for {}", new Object[]{jmsTemplate});
    }

    void publish(String destinationName, byte[] messageBytes) {
        this.publish(destinationName, messageBytes, null);
    }

    void publish(String destinationName, final byte[] messageBytes, final Map<String, String> flowFileAttributes) {
        this.jmsTemplate.send(destinationName, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                BytesMessage message = session.createBytesMessage();
                message.writeBytes(messageBytes);
                JMSPublisher.this.setMessageHeaderAndProperties((Message)message, flowFileAttributes);
                return message;
            }
        });
    }

    void publish(String destinationName, String messageText) {
        this.publish(destinationName, messageText, null);
    }

    void publish(String destinationName, final String messageText, final Map<String, String> flowFileAttributes) {
        this.jmsTemplate.send(destinationName, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                TextMessage message = session.createTextMessage(messageText);
                JMSPublisher.this.setMessageHeaderAndProperties((Message)message, flowFileAttributes);
                return message;
            }
        });
    }

    void setMessageHeaderAndProperties(Message message, Map<String, String> flowFileAttributes) throws JMSException {
        if (flowFileAttributes != null && !flowFileAttributes.isEmpty()) {
            for (Map.Entry<String, String> entry : flowFileAttributes.entrySet()) {
                try {
                    Destination destination;
                    if (!(entry.getKey().startsWith("jms_") || entry.getKey().contains("-") || entry.getKey().contains("."))) {
                        message.setStringProperty(entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals("jms_deliveryMode")) {
                        message.setJMSDeliveryMode(Integer.parseInt(entry.getValue()));
                        continue;
                    }
                    if (entry.getKey().equals("jms_expiration")) {
                        message.setJMSExpiration((long)Integer.parseInt(entry.getValue()));
                        continue;
                    }
                    if (entry.getKey().equals("jms_priority")) {
                        message.setJMSPriority(Integer.parseInt(entry.getValue()));
                        continue;
                    }
                    if (entry.getKey().equals("jms_redelivered")) {
                        message.setJMSRedelivered(Boolean.parseBoolean(entry.getValue()));
                        continue;
                    }
                    if (entry.getKey().equals("jms_timestamp")) {
                        message.setJMSTimestamp(Long.parseLong(entry.getValue()));
                        continue;
                    }
                    if (entry.getKey().equals("jms_correlationId")) {
                        message.setJMSCorrelationID(entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals("jms_type")) {
                        message.setJMSType(entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals("jms_replyTo")) {
                        destination = this.buildDestination(entry.getValue());
                        if (destination != null) {
                            message.setJMSReplyTo(destination);
                            continue;
                        }
                        this.logUnbuildableDestination(entry.getKey(), "jms_replyTo");
                        continue;
                    }
                    if (!entry.getKey().equals("jms_destination")) continue;
                    destination = this.buildDestination(entry.getValue());
                    if (destination != null) {
                        message.setJMSDestination(destination);
                        continue;
                    }
                    this.logUnbuildableDestination(entry.getKey(), "jms_destination");
                }
                catch (NumberFormatException ne) {
                    this.processLog.warn("Incompatible value for attribute " + entry.getKey() + " [" + entry.getValue() + "] is not a number. Ignoring this attribute.");
                }
            }
        }
    }

    private void logUnbuildableDestination(String destinationName, String headerName) {
        this.processLog.warn("Failed to determine destination type from destination name '{}'. The '{}' header will not be set.", new Object[]{destinationName, headerName});
    }

    private Destination buildDestination(final String destinationName) {
        Destination destination = destinationName.toLowerCase().contains("topic") ? (Destination)this.jmsTemplate.execute((SessionCallback)new SessionCallback<Topic>(){

            public Topic doInJms(Session session) throws JMSException {
                return session.createTopic(destinationName);
            }
        }) : (destinationName.toLowerCase().contains("queue") ? (Destination)this.jmsTemplate.execute((SessionCallback)new SessionCallback<Queue>(){

            public Queue doInJms(Session session) throws JMSException {
                return session.createQueue(destinationName);
            }
        }) : null);
        return destination;
    }
}

