/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.image;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Exif", "Exchangeable", "image", "file", "format", "JPG", "GIF", "PNG", "BMP", "metadata", "IPTC", "XMP"})
@CapabilityDescription(value="Extract the image metadata from flowfiles containing images. This processor relies on this metadata extractor library https://github.com/drewnoakes/metadata-extractor. It extracts a long list of metadata types including but not limited to EXIF, IPTC, XMP and Photoshop fields. For the full list visit the library's website.NOTE: The library being used loads the images into memory so extremely large images may cause problems.")
@WritesAttributes(value={@WritesAttribute(attribute="<directory name>.<tag name>", description="The extracted image metadata will be inserted with the attribute name \"<directory name>.<tag name>\". ")})
@SupportsBatching
public class ExtractImageMetadata
extends AbstractProcessor {
    public static final PropertyDescriptor MAX_NUMBER_OF_ATTRIBUTES = new PropertyDescriptor.Builder().name("Max Number of Attributes").description("Specify the max number of attributes to add to the flowfile. There is no guarantee in what order the tags will be processed. By default it will process all of them.").required(false).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    public static final Relationship SUCCESS = new Relationship.Builder().name("success").description("Any FlowFile that successfully has image metadata extracted will be routed to success").build();
    public static final Relationship FAILURE = new Relationship.Builder().name("failure").description("Any FlowFile that fails to have image metadata extracted will be routed to failure").build();
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> properties;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(MAX_NUMBER_OF_ATTRIBUTES);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(SUCCESS);
        relationships.add(FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowfile = session.get();
        if (flowfile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        final AtomicReference<Object> value = new AtomicReference<Object>(null);
        Integer max = context.getProperty(MAX_NUMBER_OF_ATTRIBUTES).asInteger();
        try {
            session.read(flowfile, new InputStreamCallback(){

                public void process(InputStream in) throws IOException {
                    try {
                        Metadata imageMetadata = ImageMetadataReader.readMetadata((InputStream)in);
                        value.set(imageMetadata);
                    }
                    catch (ImageProcessingException ex) {
                        throw new ProcessException((Throwable)ex);
                    }
                }
            });
            Metadata metadata = value.get();
            Map<String, String> results = this.getTags(max, metadata);
            if (!results.isEmpty()) {
                flowfile = session.putAllAttributes(flowfile, results);
            }
            session.transfer(flowfile, SUCCESS);
        }
        catch (ProcessException e) {
            logger.error("Failed to extract image metadata from {} due to {}", new Object[]{flowfile, e});
            session.transfer(flowfile, FAILURE);
        }
    }

    private Map<String, String> getTags(Integer max, Metadata metadata) {
        HashMap<String, String> results = new HashMap<String, String>();
        int i = 0;
        for (Directory directory : metadata.getDirectories()) {
            for (Tag tag : directory.getTags()) {
                results.put(directory.getName() + "." + tag.getTagName(), tag.getDescription());
                if (max == null || ++i < max) continue;
                return results;
            }
        }
        return results;
    }
}

