/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.properties.MultipleSensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.properties.StandardNiFiProperties;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProtectedNiFiProperties
extends StandardNiFiProperties {
    private static final Logger logger = LoggerFactory.getLogger(ProtectedNiFiProperties.class);
    private NiFiProperties niFiProperties;
    private Map<String, SensitivePropertyProvider> localProviderCache = new HashMap<String, SensitivePropertyProvider>();
    public static final String ADDITIONAL_SENSITIVE_PROPERTIES_KEY = "nifi.sensitive.props.additional.keys";
    public static final List<String> DEFAULT_SENSITIVE_PROPERTIES = new ArrayList<String>(Arrays.asList("nifi.security.keyPasswd", "nifi.security.keystorePasswd", "nifi.security.truststorePasswd", "nifi.sensitive.props.key", "nifi.provenance.repository.encryption.key"));

    public ProtectedNiFiProperties() {
        this(new StandardNiFiProperties());
    }

    public ProtectedNiFiProperties(NiFiProperties props) {
        this.niFiProperties = props;
        logger.debug("Loaded {} properties (including {} protection schemes) into ProtectedNiFiProperties", (Object)this.getPropertyKeysIncludingProtectionSchemes().size(), (Object)this.getProtectedPropertyKeys().size());
    }

    public ProtectedNiFiProperties(Properties rawProps) {
        this(new StandardNiFiProperties(rawProps));
    }

    @Override
    public String getProperty(String key) {
        return this.getInternalNiFiProperties().getProperty(key);
    }

    @Override
    public Set<String> getPropertyKeys() {
        Set<String> filteredKeys = this.getPropertyKeysIncludingProtectionSchemes();
        filteredKeys.removeIf(p -> p.endsWith(".protected"));
        return filteredKeys;
    }

    NiFiProperties getInternalNiFiProperties() {
        if (this.niFiProperties == null) {
            this.niFiProperties = new StandardNiFiProperties();
        }
        return this.niFiProperties;
    }

    @Override
    public int size() {
        return this.getPropertyKeys().size();
    }

    Set<String> getPropertyKeysIncludingProtectionSchemes() {
        return this.getInternalNiFiProperties().getPropertyKeys();
    }

    private static List<String> splitMultipleProperties(String multipleProperties) {
        if (multipleProperties == null || multipleProperties.trim().isEmpty()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> properties = new ArrayList<String>(Arrays.asList(multipleProperties.split("\\s*[,;]\\s*")));
        for (int i = 0; i < properties.size(); ++i) {
            properties.set(i, ((String)properties.get(i)).trim());
        }
        return properties;
    }

    public List<String> getSensitivePropertyKeys() {
        String additionalPropertiesString = this.getProperty(ADDITIONAL_SENSITIVE_PROPERTIES_KEY);
        if (additionalPropertiesString == null || additionalPropertiesString.trim().isEmpty()) {
            return DEFAULT_SENSITIVE_PROPERTIES;
        }
        List<String> additionalProperties = ProtectedNiFiProperties.splitMultipleProperties(additionalPropertiesString);
        if (additionalProperties.contains(ADDITIONAL_SENSITIVE_PROPERTIES_KEY)) {
            logger.warn("The key '{}' contains itself. This is poor practice and should be removed", (Object)ADDITIONAL_SENSITIVE_PROPERTIES_KEY);
            additionalProperties.remove(ADDITIONAL_SENSITIVE_PROPERTIES_KEY);
        }
        additionalProperties.addAll(DEFAULT_SENSITIVE_PROPERTIES);
        return additionalProperties;
    }

    public List<String> getPopulatedSensitivePropertyKeys() {
        List<String> allSensitiveKeys = this.getSensitivePropertyKeys();
        return allSensitiveKeys.stream().filter(k -> StringUtils.isNotBlank((CharSequence)this.getProperty((String)k))).collect(Collectors.toList());
    }

    public boolean hasProtectedKeys() {
        List<String> sensitiveKeys = this.getSensitivePropertyKeys();
        for (String k : sensitiveKeys) {
            if (!this.isPropertyProtected(k)) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> getProtectedPropertyKeys() {
        List<String> sensitiveKeys = this.getSensitivePropertyKeys();
        HashMap<String, String> traditionalProtectedProperties = new HashMap<String, String>();
        for (String key : sensitiveKeys) {
            String protection = this.getProperty(ProtectedNiFiProperties.getProtectionKey(key));
            if (!StringUtils.isNotBlank((CharSequence)protection) || !StringUtils.isNotBlank((CharSequence)this.getProperty(key))) continue;
            traditionalProtectedProperties.put(key, protection);
        }
        return traditionalProtectedProperties;
    }

    public Set<String> getProtectionSchemes() {
        return new HashSet<String>(this.getProtectedPropertyKeys().values());
    }

    public int getPercentOfSensitivePropertiesProtected() {
        return (int)Math.round((double)this.getProtectedPropertyKeys().size() / (double)this.getPopulatedSensitivePropertyKeys().size() * 100.0);
    }

    public boolean isPropertySensitive(String key) {
        return key != null && !key.equals(ADDITIONAL_SENSITIVE_PROPERTIES_KEY) && this.getSensitivePropertyKeys().contains(key.trim());
    }

    public boolean isPropertyProtected(String key) {
        return key != null && this.isPropertySensitive(key) && !StringUtils.isBlank((CharSequence)this.getProperty(ProtectedNiFiProperties.getProtectionKey(key)));
    }

    public static String getProtectionKey(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Cannot find protection key for null key");
        }
        return key + ".protected";
    }

    public NiFiProperties getUnprotectedProperties() throws SensitivePropertyProtectionException {
        if (this.hasProtectedKeys()) {
            logger.info("There are {} protected properties of {} sensitive properties ({}%)", new Object[]{this.getProtectedPropertyKeys().size(), this.getSensitivePropertyKeys().size(), this.getPercentOfSensitivePropertiesProtected()});
            Properties rawProperties = new Properties();
            HashSet<String> failedKeys = new HashSet<String>();
            for (String key : this.getPropertyKeys()) {
                if (key.endsWith(".protected")) continue;
                if (this.isPropertyProtected(key)) {
                    try {
                        rawProperties.setProperty(key, this.unprotectValue(key, this.getProperty(key)));
                    }
                    catch (SensitivePropertyProtectionException e) {
                        logger.warn("Failed to unprotect '{}'", (Object)key, (Object)e);
                        failedKeys.add(key);
                    }
                    continue;
                }
                rawProperties.setProperty(key, this.getProperty(key));
            }
            if (!failedKeys.isEmpty()) {
                if (failedKeys.size() > 1) {
                    logger.warn("Combining {} failed keys [{}] into single exception", (Object)failedKeys.size(), (Object)StringUtils.join(failedKeys, (String)", "));
                    throw new MultipleSensitivePropertyProtectionException("Failed to unprotect keys", failedKeys);
                }
                throw new SensitivePropertyProtectionException("Failed to unprotect key " + (String)failedKeys.iterator().next());
            }
            StandardNiFiProperties unprotected = new StandardNiFiProperties(rawProperties);
            return unprotected;
        }
        logger.debug("No protected properties");
        return this.getInternalNiFiProperties();
    }

    void addSensitivePropertyProvider(SensitivePropertyProvider sensitivePropertyProvider) {
        if (sensitivePropertyProvider == null) {
            throw new IllegalArgumentException("Cannot add null SensitivePropertyProvider");
        }
        if (this.getSensitivePropertyProviders().containsKey(sensitivePropertyProvider.getIdentifierKey())) {
            throw new UnsupportedOperationException("Cannot overwrite existing sensitive property provider registered for " + sensitivePropertyProvider.getIdentifierKey());
        }
        this.getSensitivePropertyProviders().put(sensitivePropertyProvider.getIdentifierKey(), sensitivePropertyProvider);
    }

    private String getDefaultProtectionScheme() {
        if (!this.getSensitivePropertyProviders().isEmpty()) {
            ArrayList<String> schemes = new ArrayList<String>(this.getSensitivePropertyProviders().keySet());
            Collections.sort(schemes);
            return (String)schemes.get(0);
        }
        throw new IllegalStateException("No registered protection schemes");
    }

    NiFiProperties protectPlainProperties() {
        try {
            return this.protectPlainProperties(this.getDefaultProtectionScheme());
        }
        catch (IllegalStateException e) {
            String msg = "Cannot protect properties with default scheme if no protection schemes are registered";
            logger.warn("Cannot protect properties with default scheme if no protection schemes are registered");
            throw new IllegalStateException("Cannot protect properties with default scheme if no protection schemes are registered", e);
        }
    }

    NiFiProperties protectPlainProperties(String protectionScheme) {
        SensitivePropertyProvider spp = this.getSensitivePropertyProvider(protectionScheme);
        Properties protectedProperties = new Properties();
        Set<String> plainKeys = this.getPropertyKeys();
        plainKeys.removeAll(this.getSensitivePropertyKeys());
        for (String key : plainKeys) {
            protectedProperties.setProperty(key, this.getInternalNiFiProperties().getProperty(key));
        }
        for (String key : this.getSensitivePropertyKeys()) {
            String plainValue = this.getInternalNiFiProperties().getProperty(key);
            if (plainValue == null || plainValue.trim().isEmpty()) continue;
            String protectedValue = spp.protect(plainValue);
            protectedProperties.setProperty(key, protectedValue);
            protectedProperties.setProperty(ProtectedNiFiProperties.getProtectionKey(key), protectionScheme);
        }
        return new StandardNiFiProperties(protectedProperties);
    }

    public static int countProtectedProperties(NiFiProperties plainProperties) {
        return new ProtectedNiFiProperties(plainProperties).getProtectedPropertyKeys().size();
    }

    public static int countSensitiveProperties(NiFiProperties plainProperties) {
        return new ProtectedNiFiProperties(plainProperties).getSensitivePropertyKeys().size();
    }

    @Override
    public String toString() {
        Set<String> providers = this.getSensitivePropertyProviders().keySet();
        return "ProtectedNiFiProperties instance with " + this.size() + " properties (" + this.getProtectedPropertyKeys().size() + " protected) and " + providers.size() + " sensitive property providers: " + StringUtils.join(providers, (String)", ");
    }

    private Map<String, SensitivePropertyProvider> getSensitivePropertyProviders() {
        if (this.localProviderCache == null) {
            this.localProviderCache = new HashMap<String, SensitivePropertyProvider>();
        }
        return this.localProviderCache;
    }

    private SensitivePropertyProvider getSensitivePropertyProvider(String protectionScheme) {
        if (this.isProviderAvailable(protectionScheme)) {
            return this.getSensitivePropertyProviders().get(protectionScheme);
        }
        throw new SensitivePropertyProtectionException("No provider available for " + protectionScheme);
    }

    private boolean isProviderAvailable(String protectionScheme) {
        return this.getSensitivePropertyProviders().containsKey(protectionScheme);
    }

    private String unprotectValue(String key, String retrievedValue) {
        if (this.isPropertyProtected(key)) {
            String protectionScheme = this.getProperty(ProtectedNiFiProperties.getProtectionKey(key));
            if (!this.isProviderAvailable(protectionScheme)) {
                logger.warn("No provider available for {} so passing the protected {} value back", (Object)protectionScheme, (Object)key);
                return retrievedValue;
            }
            try {
                SensitivePropertyProvider sensitivePropertyProvider = this.getSensitivePropertyProvider(protectionScheme);
                return sensitivePropertyProvider.unprotect(retrievedValue);
            }
            catch (SensitivePropertyProtectionException e) {
                throw new SensitivePropertyProtectionException("Error unprotecting value for " + key, e.getCause());
            }
        }
        return retrievedValue;
    }
}

