/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public final class SslContextFactory {
    public static SSLContext createSslContext(String keystore, char[] keystorePasswd, String keystoreType, String truststore, char[] truststorePasswd, String truststoreType, ClientAuth clientAuth, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance(keystoreType);
        try (FileInputStream keyStoreStream = new FileInputStream(keystore);){
            keyStore.load(keyStoreStream, keystorePasswd);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keystorePasswd);
        KeyStore trustStore = KeyStore.getInstance(truststoreType);
        try (FileInputStream trustStoreStream = new FileInputStream(truststore);){
            trustStore.load(trustStoreStream, truststorePasswd);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        SSLContext sslContext = SSLContext.getInstance(protocol);
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        if (ClientAuth.REQUIRED == clientAuth) {
            sslContext.getDefaultSSLParameters().setNeedClientAuth(true);
        } else if (ClientAuth.WANT == clientAuth) {
            sslContext.getDefaultSSLParameters().setWantClientAuth(true);
        } else {
            sslContext.getDefaultSSLParameters().setWantClientAuth(false);
        }
        return sslContext;
    }

    public static SSLContext createSslContext(String keystore, char[] keystorePasswd, String keystoreType, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance(keystoreType);
        try (FileInputStream keyStoreStream = new FileInputStream(keystore);){
            keyStore.load(keyStoreStream, keystorePasswd);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keystorePasswd);
        SSLContext ctx = SSLContext.getInstance(protocol);
        ctx.init(keyManagerFactory.getKeyManagers(), new TrustManager[0], new SecureRandom());
        return ctx;
    }

    public static SSLContext createTrustSslContext(String truststore, char[] truststorePasswd, String truststoreType, String protocol) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        KeyStore trustStore = KeyStore.getInstance(truststoreType);
        try (FileInputStream trustStoreStream = new FileInputStream(truststore);){
            trustStore.load(trustStoreStream, truststorePasswd);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        SSLContext ctx = SSLContext.getInstance(protocol);
        ctx.init(new KeyManager[0], trustManagerFactory.getTrustManagers(), new SecureRandom());
        return ctx;
    }

    public static enum ClientAuth {
        WANT,
        REQUIRED,
        NONE;

    }
}

